/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.path.RelationshipTypeAndDirections;
import apoc.result.ListResult;
import apoc.result.NodeResult;
import apoc.util.MapUtil;
import apoc.util.Util;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Sort;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SortedIndexReader;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SchemaIndex {
    @Context
    public GraphDatabaseAPI db;
    @Context
    public KernelTransaction tx;

    @Procedure
    @Deprecated
    @Description(value="apoc.index.relatedNodes([nodes],label,key,'<TYPE'/'TYPE>'/'TYPE',limit) yield node - schema range scan which keeps index order and adds limit and checks opposite node of relationship against the given set of nodes")
    public Stream<NodeResult> related(@Name(value="nodes") List<Node> nodes, @Name(value="label") String label, @Name(value="key") String key, @Name(value="relationship") String relationship, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException, IndexNotApplicableKernelException {
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        Pair<RelationshipType, Direction> relTypeDirection = RelationshipTypeAndDirections.parse(relationship).get(0);
        RelationshipType type = (RelationshipType)relTypeDirection.first();
        Direction dir = (Direction)relTypeDirection.other();
        return this.queryForRange(label, key, Long.MIN_VALUE, Long.MAX_VALUE, 0L).filter(node -> {
            for (Relationship rel : node.getRelationships(dir, new RelationshipType[]{type})) {
                Node other = rel.getOtherNode(node);
                if (!nodeSet.contains(other)) continue;
                return true;
            }
            return false;
        }).map(NodeResult::new).limit(limit);
    }

    @Procedure
    @Deprecated
    @Description(value="just use a cypher query with a range predicate on an indexed field and wait for index backed order by in 3.5")
    public Stream<NodeResult> orderedRange(@Name(value="label") String label, @Name(value="key") String key, @Name(value="min") Object min, @Name(value="max") Object max, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        return this.queryForRange(label, key, min, max, limit).map(NodeResult::new);
    }

    public Stream<Node> queryForRange(@Name(value="label") String label, @Name(value="key") String key, @Name(value="min") Object min, @Name(value="max") Object max, @Name(value="limit") long limit) {
        Map<String, Object> params = MapUtil.map("min", min, "max", max, "limit", limit);
        String query = "MATCH (n:`" + label + "`)";
        if (min != null || max != null) {
            query = query + " WHERE ";
            if (min != null) {
                query = query + "{min} <=";
            }
            query = query + " n.`" + key + "` ";
            if (max != null) {
                query = query + "<= {max}";
            }
        }
        query = query + " RETURN n ";
        if (limit > 0L) {
            query = query + "LIMIT {limit}";
        }
        ResourceIterator it = this.db.execute(query, params).columnAs("n");
        return (Stream)it.stream().onClose(() -> ((ResourceIterator)it).close());
    }

    public Sort getSort(Object min, Object max, boolean relevance) {
        return Sort.RELEVANCE;
    }

    private PrimitiveLongIterator queryForRange(SortedIndexReader sortedIndexReader, Object min, Object max) {
        if ((min == null || min instanceof Number) && (max == null || max instanceof Number)) {
            return sortedIndexReader.rangeSeekByNumberInclusive((Number)min, (Number)max);
        }
        String minValue = min == null ? null : min.toString();
        String maxValue = max == null ? null : max.toString();
        return sortedIndexReader.rangeSeekByString(minValue, true, maxValue, true);
    }

    @Procedure
    @Deprecated
    @Description(value="just use a cypher query with a range predicate on an indexed field and wait for index backed order by in 3.5")
    public Stream<NodeResult> orderedByText(@Name(value="label") String label, @Name(value="key") String key, @Name(value="operator") String operator, @Name(value="value") String value, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        SortedIndexReader sortedIndexReader = this.getSortedIndexReader(label, key, limit, this.getSort(value, value, relevance));
        PrimitiveLongIterator it = this.queryForString(sortedIndexReader, operator, value);
        return Util.toLongStream(it).mapToObj(id -> new NodeResult(this.db.getNodeById(id)));
    }

    private PrimitiveLongIterator queryForString(SortedIndexReader sortedIndexReader, String operator, String value) {
        switch (operator.trim().toUpperCase()) {
            case "CONTAINS": {
                return sortedIndexReader.containsString(value);
            }
            case "STARTS WITH": {
                return sortedIndexReader.rangeSeekByPrefix(value);
            }
            case "ENDS WITH": {
                return sortedIndexReader.containsString('*' + value);
            }
        }
        throw new IllegalArgumentException("Unknown Operator " + operator);
    }

    private SortedIndexReader getSortedIndexReader(String label, String key, long limit, Sort sort) throws IndexNotFoundKernelException {
        SimpleIndexReader reader = this.getLuceneIndexReader(label, key);
        return new SortedIndexReader(reader, limit, sort);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleIndexReader getLuceneIndexReader(String label, String key) throws IndexNotFoundKernelException {
        stmt = (KernelStatement)this.tx.acquireStatement();
        var4_4 = null;
        try {
            tokenRead = this.tx.tokenRead();
            labelSchemaDescriptor = SchemaDescriptorFactory.forLabel((int)tokenRead.nodeLabel(label), (int[])new int[]{tokenRead.propertyKey(key)});
            recordStorageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            descriptor = recordStorageEngine.storeReadLayer().indexGetForSchema((SchemaDescriptor)labelSchemaDescriptor);
            indexReader = stmt.getStoreStatement().getIndexReader(descriptor);
            if (indexReader instanceof FusionIndexBase) {
                try {
                    selectorField = FusionIndexBase.class.getDeclaredField("instanceSelector");
                    selectorField.setAccessible(true);
                    instanceSelector = selectorField.get(indexReader);
                    instancesField = this.getDeclaredField(instanceSelector, "instances");
                    instancesField.setAccessible(true);
                    var14_18 = instances = (org.neo4j.storageengine.api.schema.IndexReader[])instancesField.get(instanceSelector);
                    var15_19 = var14_18.length;
                    var16_20 = 0;
lbl19:
                    // 2 sources

                    while (true) {
                        if (var16_20 >= var15_19) throw new IllegalStateException("No Lucene Index Reader found");
                        instance = var14_18[var16_20];
                        if (instance instanceof SimpleIndexReader) {
                            var18_22 = (SimpleIndexReader)instance;
                            return var18_22;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error accessing index reader", e);
                }
                {
                    ++var16_20;
                    ** continue;
                }
            }
            var10_13 = (SimpleIndexReader)indexReader;
            return var10_13;
        }
        catch (Throwable var5_6) {
            var4_4 = var5_6;
            throw var5_6;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable var19_23) {
                        var4_4.addSuppressed(var19_23);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    private Field getDeclaredField(Object instance, String name) throws NoSuchFieldException {
        Class<?> type = instance.getClass();
        while (true) {
            try {
                return type.getDeclaredField(name);
            }
            catch (NoSuchFieldException nsfe) {
                if ((type = type.getSuperclass()) != null) continue;
                throw nsfe;
            }
            break;
        }
    }

    @Procedure(value="apoc.schema.properties.distinct")
    @Description(value="apoc.schema.properties.distinct(label, key) - quickly returns all distinct values for a given key")
    public Stream<ListResult> distinct(@Name(value="label") String label, @Name(value="key") String key) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException {
        List<Object> values = this.distinctTerms(label, key);
        return Stream.of(new ListResult(values));
    }

    private List<Object> distinctTerms(@Name(value="label") String label, @Name(value="key") String key) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException {
        SimpleIndexReader reader = this.getLuceneIndexReader(label, key);
        SortedIndexReader sortedIndexReader = new SortedIndexReader(reader, 0L, Sort.INDEXORDER);
        LinkedHashSet<String> values = new LinkedHashSet<String>(100);
        Fields fields = MultiFields.getFields((IndexReader)sortedIndexReader.getIndexSearcher().getIndexReader());
        Terms terms = fields.terms("string");
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator();
            while (termsEnum.next() != null) {
                values.add(termsEnum.term().utf8ToString());
            }
        }
        return new ArrayList<Object>(values);
    }

    @Procedure(value="apoc.schema.properties.distinctCount")
    @Description(value="apoc.schema.properties.distinctCount([label], [key]) YIELD label, key, value, count - quickly returns all distinct values and counts for a given key")
    public Stream<PropertyValueCount> distinctCount(@Name(value="label", defaultValue="") String labelName, @Name(value="key", defaultValue="") String keyName) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException {
        Iterable labels = labelName.isEmpty() ? this.db.schema().getIndexes() : this.db.schema().getIndexes(Label.label((String)labelName));
        return StreamSupport.stream(labels.spliterator(), false).filter(i -> keyName.isEmpty() || this.isKeyIndexed((IndexDefinition)i, keyName)).flatMap(index -> {
            List<String> keys = keyName.isEmpty() ? index.getPropertyKeys() : Collections.singletonList(keyName);
            return StreamSupport.stream(keys.spliterator(), false).flatMap(key -> {
                String label = index.getLabel().name();
                return this.distinctTermsCount(label, (String)key).entrySet().stream().map(e -> new PropertyValueCount(label, (String)key, (String)e.getKey(), ((Integer)e.getValue()).intValue()));
            });
        });
    }

    private boolean isKeyIndexed(@Name(value="index") IndexDefinition index, @Name(value="key") String key) {
        return StreamSupport.stream(index.getPropertyKeys().spliterator(), false).anyMatch(k -> k.equals(key));
    }

    private Map<String, Integer> distinctTermsCount(@Name(value="label") String label, @Name(value="key") String key) {
        try {
            SortedIndexReader sortedIndexReader = this.getSortedIndexReader(label, key, 0L, Sort.INDEXORDER);
            Fields fields = MultiFields.getFields((IndexReader)sortedIndexReader.getIndexSearcher().getIndexReader());
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            Terms terms = fields.terms("string");
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    values.put(termsEnum.term().utf8ToString(), termsEnum.docFreq());
                }
            }
            return values;
        }
        catch (Exception e) {
            throw new RuntimeException("Error collecting distinct terms of label: " + label + " and key: " + key, e);
        }
    }

    public static class PropertyValueCount {
        public String label;
        public String key;
        public String value;
        public long count;

        public PropertyValueCount(String label, String key, String value, long count) {
            this.label = label;
            this.key = key;
            this.value = value;
            this.count = count;
        }
    }
}

