/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.export.util.CountingReader;
import apoc.meta.Meta;
import apoc.util.FileUtils;
import apoc.util.Util;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LoadCsv {
    public static final char DEFAULT_ARRAY_SEP = ';';
    public static final char DEFAULT_SEP = ',';
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.load.csv('url',{config}) YIELD lineNo, list, map - load CSV fom URL as stream of values,\n config contains any of: {skip:1,limit:5,header:false,sep:'TAB',ignore:['tmp'],nullValues:['na'],arraySep:';',mapping:{years:{type:'int',arraySep:'-',array:false,name:'age',ignore:false}}")
    public Stream<CSVResult> csv(@Name(value="url") String url, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean failOnError = this.booleanValue(config, "failOnError", true);
        try {
            CountingReader reader = FileUtils.readerFor(url);
            char separator = this.separator(config, "sep", ',');
            char arraySep = this.separator(config, "arraySep", ';');
            long skip = this.longValue(config, "skip", 0L);
            boolean hasHeader = this.booleanValue(config, "header", true);
            long limit = this.longValue(config, "limit", Long.MAX_VALUE);
            EnumSet<Results> results = EnumSet.noneOf(Results.class);
            for (String result : this.value(config, "results", Arrays.asList("map", "list"))) {
                results.add(Results.valueOf(result));
            }
            List<String> ignore = this.value(config, "ignore", Collections.emptyList());
            List<String> nullValues = this.value(config, "nullValues", Collections.emptyList());
            Map<String, Map<String, Object>> mapping = this.value(config, "mapping", Collections.emptyMap());
            Map<String, Mapping> mappings = this.createMapping(mapping, arraySep, ignore);
            CSVReader csv = new CSVReader((Reader)reader, separator);
            String[] header = this.getHeader(hasHeader, csv, ignore, mappings);
            boolean checkIgnore = !ignore.isEmpty() || mappings.values().stream().anyMatch(m -> m.ignore);
            return StreamSupport.stream(new CSVSpliterator(csv, header, url, skip, limit, checkIgnore, mappings, nullValues, results), false);
        }
        catch (IOException e) {
            if (!failOnError) {
                return Stream.of(new CSVResult(new String[0], new String[0], 0L, true, Collections.emptyMap(), Collections.emptyList(), EnumSet.noneOf(Results.class)));
            }
            throw new RuntimeException("Can't read CSV from URL " + Util.cleanUrl(url), e);
        }
    }

    private Map<String, Mapping> createMapping(Map<String, Map<String, Object>> mapping, char arraySep, List<String> ignore) {
        if (mapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Mapping> result = new HashMap<String, Mapping>(mapping.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapping.entrySet()) {
            String name = entry.getKey();
            result.put(name, new Mapping(name, entry.getValue(), arraySep, ignore.contains(name)));
        }
        return result;
    }

    private String[] getHeader(boolean hasHeader, CSVReader csv, List<String> ignore, Map<String, Mapping> mapping) throws IOException {
        if (!hasHeader) {
            return null;
        }
        String[] header = csv.readNext();
        if (ignore.isEmpty()) {
            return header;
        }
        for (int i = 0; i < header.length; ++i) {
            if (!ignore.contains(header[i]) && !mapping.getOrDefault((Object)header[i], (Mapping)Mapping.EMPTY).ignore) continue;
            header[i] = null;
        }
        return header;
    }

    private boolean booleanValue(Map<String, Object> config, String key, boolean defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private long longValue(Map<String, Object> config, String key, long defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private <T> T value(Map<String, Object> config, String key, T defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        return (T)config.get(key);
    }

    private char separator(Map<String, Object> config, String key, char defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value == null) {
            return defaultValue;
        }
        return LoadCsv.separator(value.toString(), defaultValue);
    }

    private static char separator(String separator, char defaultSep) {
        if (separator == null) {
            return defaultSep;
        }
        if ("TAB".equalsIgnoreCase(separator)) {
            return '\t';
        }
        return separator.charAt(0);
    }

    private static class CSVSpliterator
    extends Spliterators.AbstractSpliterator<CSVResult> {
        private final CSVReader csv;
        private final String[] header;
        private final String url;
        private final long limit;
        private final boolean ignore;
        private final Map<String, Mapping> mapping;
        private final List<String> nullValues;
        private final EnumSet<Results> results;
        long lineNo;

        public CSVSpliterator(CSVReader csv, String[] header, String url, long skip, long limit, boolean ignore, Map<String, Mapping> mapping, List<String> nullValues, EnumSet<Results> results) throws IOException {
            super(Long.MAX_VALUE, 16);
            this.csv = csv;
            this.header = header;
            this.url = url;
            this.ignore = ignore;
            this.mapping = mapping;
            this.nullValues = nullValues;
            this.results = results;
            this.limit = skip + limit;
            this.lineNo = skip;
            while (skip-- > 0L) {
                csv.readNext();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super CSVResult> action) {
            try {
                String[] row = this.csv.readNext();
                if (row != null && this.lineNo < this.limit) {
                    action.accept(new CSVResult(this.header, row, this.lineNo++, this.ignore, this.mapping, this.nullValues, this.results));
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading CSV from URL " + Util.cleanUrl(this.url) + " at " + this.lineNo, e);
            }
        }
    }

    public static class CSVResult {
        public long lineNo;
        public List<Object> list;
        public List<String> strings;
        public Map<String, Object> map;
        public Map<String, String> stringMap;

        public CSVResult(String[] header, String[] list, long lineNo, boolean ignore, Map<String, Mapping> mapping, List<String> nullValues, EnumSet<Results> results) {
            this.lineNo = lineNo;
            this.removeNullValues(list, nullValues);
            this.strings = results.contains((Object)Results.strings) ? this.createList(header, list, ignore, mapping, false) : Collections.emptyList();
            this.stringMap = results.contains((Object)Results.stringMap) ? this.createMap(header, list, ignore, mapping, false) : Collections.emptyMap();
            this.map = results.contains((Object)Results.map) ? this.createMap(header, list, ignore, mapping, true) : Collections.emptyMap();
            this.list = results.contains((Object)Results.list) ? this.createList(header, list, ignore, mapping, true) : Collections.emptyList();
        }

        public void removeNullValues(String[] list, List<String> nullValues) {
            if (nullValues.isEmpty()) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                if (!nullValues.contains(list[i])) continue;
                list[i] = null;
            }
        }

        private List<Object> createList(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
            if (!ignore && mappings.isEmpty()) {
                return Arrays.asList((Object[])list);
            }
            ArrayList<Object> result = new ArrayList<Object>(list.length);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping != null) {
                    if (mapping.ignore) continue;
                    result.add(convert ? mapping.convert(list[i]) : list[i]);
                    continue;
                }
                result.add(list[i]);
            }
            return result;
        }

        private Map<String, Object> createMap(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
            if (header == null) {
                return null;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(header.length, 1.0f);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (ignore && name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping == null) {
                    map.put(name, list[i]);
                    continue;
                }
                if (mapping.ignore) continue;
                map.put(mapping.name, convert ? mapping.convert(list[i]) : list[i]);
            }
            return map;
        }
    }

    public static class Mapping {
        public static final Mapping EMPTY = new Mapping("", Collections.emptyMap(), ';', false);
        final String name;
        final Collection<String> nullValues;
        final Meta.Types type;
        final boolean array;
        final boolean ignore;
        final char arraySep;
        private final Pattern arrayPattern;

        public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
            this.name = mapping.getOrDefault("name", name).toString();
            this.array = (Boolean)mapping.getOrDefault("array", false);
            this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
            this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
            this.arraySep = LoadCsv.separator(mapping.getOrDefault("arraySep", Character.valueOf(arraySep)).toString(), ';');
            this.type = Meta.Types.from(mapping.getOrDefault("type", "STRING").toString());
            this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
        }

        public Object convert(String value) {
            return this.array ? this.convertArray(value) : this.convertType(value);
        }

        private Object convertArray(String value) {
            String[] values = this.arrayPattern.split(value);
            ArrayList<Object> result = new ArrayList<Object>(values.length);
            for (String v : values) {
                result.add(this.convertType(v));
            }
            return result;
        }

        private Object convertType(String value) {
            if (this.nullValues.contains(value)) {
                return null;
            }
            if (this.type == Meta.Types.STRING) {
                return value;
            }
            switch (this.type) {
                case INTEGER: {
                    return Util.toLong(value);
                }
                case FLOAT: {
                    return Util.toDouble(value);
                }
                case BOOLEAN: {
                    return Util.toBoolean(value);
                }
                case NULL: {
                    return null;
                }
                case LIST: {
                    return Arrays.stream(this.arrayPattern.split(value)).map(this::convertType).collect(Collectors.toList());
                }
            }
            return value;
        }
    }

    public static enum Results {
        map,
        list,
        strings,
        stringMap;

    }
}

