/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.result.MapResult;
import apoc.result.ObjectResult;
import apoc.util.JsonUtil;
import apoc.util.MapUtil;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LoadJson {
    private static final String AUTH_HEADER_KEY = "Authorization";
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.load.jsonArray('url') YIELD value - load array from JSON URL (e.g. web-api) to import JSON as stream of values")
    public Stream<ObjectResult> jsonArray(@Name(value="url") String url, @Name(value="path", defaultValue="") String path) {
        return JsonUtil.loadJson(url, null, null, path, true).flatMap(value -> {
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return Stream.empty();
                }
                if (list.get(0) instanceof Map) {
                    return list.stream().map(ObjectResult::new);
                }
            }
            return Stream.of(new ObjectResult(value));
        });
    }

    @Procedure
    @Description(value="apoc.load.json('url',path, config) YIELD value -  import JSON as stream of values if the JSON was an array or a single value if it was a map")
    public Stream<MapResult> json(@Name(value="url") String url, @Name(value="path", defaultValue="") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.jsonParams(url, null, null, path, config);
    }

    @Procedure
    @Description(value="apoc.load.jsonParams('url',{header:value},payload, config) YIELD value - load from JSON URL (e.g. web-api) while sending headers / payload to import JSON as stream of values if the JSON was an array or a single value if it was a map")
    public Stream<MapResult> jsonParams(@Name(value="url") String url, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload, @Name(value="path", defaultValue="") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        return LoadJson.loadJsonStream(url, headers, payload, path, failOnError);
    }

    public static Stream<MapResult> loadJsonStream(@Name(value="url") String url, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload) {
        return LoadJson.loadJsonStream(url, headers, payload, "", true);
    }

    public static Stream<MapResult> loadJsonStream(@Name(value="url") String url, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload, String path, boolean failOnError) {
        headers = null != headers ? headers : new HashMap<String, Object>();
        headers.putAll(LoadJson.extractCredentialsIfNeeded(url, failOnError));
        Stream<Object> stream = JsonUtil.loadJson(url, headers, payload, path, failOnError);
        return stream.flatMap(value -> {
            if (value instanceof Map) {
                return Stream.of(new MapResult((Map)value));
            }
            if (value instanceof List) {
                if (((List)value).isEmpty()) {
                    return Stream.empty();
                }
                if (((List)value).get(0) instanceof Map) {
                    return ((List)value).stream().map(v -> new MapResult((Map)v));
                }
                return Stream.of(new MapResult(Collections.singletonMap("result", value)));
            }
            if (!failOnError) {
                throw new RuntimeException("Incompatible Type " + (value == null ? "null" : value.getClass()));
            }
            return Stream.of(new MapResult(Collections.emptyMap()));
        });
    }

    private static Map<String, Object> extractCredentialsIfNeeded(String url, boolean failOnError) {
        try {
            String[] parts;
            URI uri = new URI(url);
            String authInfo = uri.getUserInfo();
            if (null != authInfo && 2 == (parts = authInfo.split(":")).length) {
                String token = new String(Base64.getEncoder().encode(authInfo.getBytes()));
                return MapUtil.map(AUTH_HEADER_KEY, "Basic " + token);
            }
        }
        catch (Exception e) {
            if (!failOnError) {
                return Collections.emptyMap();
            }
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }
}

