/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.result.MapResult;
import apoc.result.NodeResult;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Xml {
    public static final XMLInputFactory FACTORY = XMLInputFactory.newFactory();
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Procedure
    @Description(value="apoc.load.xml('http://example.com/test.xml', 'xPath',config, false) YIELD value as doc CREATE (p:Person) SET p.name = doc.name load from XML URL (e.g. web-api) to import XML as single nested map with attributes and _type, _text and _childrenx fields.")
    public Stream<MapResult> xml(@Name(value="url") String url, @Name(value="path", defaultValue="/") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config, @Name(value="simple", defaultValue="false") boolean simpleMode) throws Exception {
        return this.xmlXpathToMapResult(url, simpleMode, path, config);
    }

    @Procedure(deprecatedBy="apoc.load.xml")
    @Deprecated
    @Description(value="apoc.load.xmlSimple('http://example.com/test.xml') YIELD value as doc CREATE (p:Person) SET p.name = doc.name load from XML URL (e.g. web-api) to import XML as single nested map with attributes and _type, _text and _children fields. This method does intentionally not work with XML mixed content.")
    public Stream<MapResult> xmlSimple(@Name(value="url") String url) throws Exception {
        return this.xmlToMapResult(url, true);
    }

    private Stream<MapResult> xmlXpathToMapResult(@Name(value="url") String url, boolean simpleMode, String path, Map<String, Object> config) throws Exception {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        ArrayList<MapResult> result = new ArrayList<MapResult>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileUtils.checkReadAllowed(url);
            Map<String, Object> headers = config.getOrDefault("headers", Collections.emptyMap());
            Document doc = documentBuilder.parse(Util.openInputStream(url, headers, null));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            path = StringUtils.isEmpty((CharSequence)path) ? "/" : path;
            XPathExpression xPathExpression = xPath.compile(path);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
                this.handleNode(stack, nodeList.item(i), simpleMode);
                for (int index = 0; index < stack.size(); ++index) {
                    result.add(new MapResult((Map)stack.pollFirst()));
                }
            }
        }
        catch (FileNotFoundException e) {
            if (!failOnError) {
                return Stream.of(new MapResult(Collections.emptyMap()));
            }
            throw new FileNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            if (!failOnError) {
                return Stream.of(new MapResult(Collections.emptyMap()));
            }
            throw new Exception(e);
        }
        return result.stream();
    }

    private Stream<MapResult> xmlToMapResult(@Name(value="url") String url, boolean simpleMode) {
        try {
            XMLStreamReader reader = this.getXMLStreamReaderFromUrl(url);
            LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
            do {
                this.handleXmlEvent(stack, reader, simpleMode);
            } while (this.proceedReader(reader));
            return Stream.of(new MapResult((Map)stack.getFirst()));
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Can't read url " + Util.cleanUrl(url) + " as XML", e);
        }
    }

    private XMLStreamReader getXMLStreamReaderFromUrl(String url) throws IOException, XMLStreamException {
        FileUtils.checkReadAllowed(url);
        URLConnection urlConnection = new URL(url).openConnection();
        FACTORY.setProperty("javax.xml.stream.isCoalescing", true);
        return FACTORY.createXMLStreamReader(urlConnection.getInputStream());
    }

    private boolean proceedReader(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            do {
                reader.next();
            } while (reader.isWhiteSpace());
            return true;
        }
        return false;
    }

    private void handleXmlEvent(Deque<Map<String, Object>> stack, XMLStreamReader reader, boolean simpleMode) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 7: 
            case 8: {
                break;
            }
            case 1: {
                int attributes = reader.getAttributeCount();
                LinkedHashMap<String, String> elementMap = new LinkedHashMap<String, String>(attributes + 3);
                elementMap.put("_type", reader.getLocalName());
                for (int a = 0; a < attributes; ++a) {
                    elementMap.put(reader.getAttributeLocalName(a), reader.getAttributeValue(a));
                }
                if (!stack.isEmpty()) {
                    Map<String, Object> last = stack.getLast();
                    String key = simpleMode ? "_" + reader.getLocalName() : "_children";
                    this.amendToList(last, key, elementMap);
                }
                stack.addLast(elementMap);
                break;
            }
            case 2: {
                Map<String, Object> elementMap = stack.size() > 1 ? stack.removeLast() : stack.getLast();
                Object children = elementMap.get("_children");
                if (children == null || !(children instanceof String) && !this.collectionIsAllStrings(children)) break;
                elementMap.put("_text", children);
                elementMap.remove("_children");
                break;
            }
            case 4: {
                String text = reader.getText().trim();
                if (text.isEmpty()) break;
                Map<String, Object> map = stack.getLast();
                this.amendToList(map, "_children", text);
                break;
            }
            default: {
                throw new RuntimeException("dunno know how to handle xml event type " + reader.getEventType());
            }
        }
    }

    private void handleNode(Deque<Map<String, Object>> stack, org.w3c.dom.Node node, boolean simpleMode) {
        if (node.getNodeType() == 9) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getLocalName() == null) continue;
                this.handleNode(stack, children.item(i), simpleMode);
                return;
            }
        }
        LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
        this.handleTypeAndAttributes(node, elementMap);
        NodeList children = node.getChildNodes();
        int count = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                this.handleNode(stack, child, simpleMode);
                ++count;
                continue;
            }
            this.handleTextNode(child, elementMap);
        }
        if (children.getLength() > 1 && !stack.isEmpty()) {
            ArrayList<Map<String, Object>> nodeChildren = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < count; ++i) {
                nodeChildren.add(stack.pollLast());
            }
            String key = simpleMode ? "_" + node.getLocalName() : "_children";
            Collections.reverse(nodeChildren);
            if (nodeChildren.size() > 0) {
                Object text = elementMap.get("_text");
                if (text instanceof List) {
                    for (Object element : (List)text) {
                        nodeChildren.add((Map<String, Object>)element);
                    }
                    elementMap.remove("_text");
                }
                elementMap.put(key, nodeChildren);
            }
        }
        if (!elementMap.isEmpty()) {
            stack.addLast(elementMap);
        }
    }

    private void handleTypeAndAttributes(org.w3c.dom.Node node, Map<String, Object> elementMap) {
        if (node.getLocalName() != null) {
            elementMap.put("_type", node.getLocalName());
        }
        if (node.getAttributes() != null) {
            NamedNodeMap attributeMap = node.getAttributes();
            for (int i = 0; i < attributeMap.getLength(); ++i) {
                org.w3c.dom.Node attribute = attributeMap.item(i);
                elementMap.put(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    private void handleTextNode(org.w3c.dom.Node node, Map<String, Object> elementMap) {
        Object text = "";
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 3: {
                text = this.normalizeText(node.getNodeValue());
                break;
            }
            case 4: {
                text = this.normalizeText(((CharacterData)node).getData());
                break;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)text.toString())) {
            Object previousText = elementMap.get("_text");
            if (previousText != null) {
                text = Arrays.asList(previousText.toString(), text);
            }
            elementMap.put("_text", text);
        }
    }

    private String normalizeText(String text) {
        Object[] tokens = StringUtils.split((String)text, (String)"\n");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = ((String)tokens[i]).trim();
        }
        return StringUtils.join((Object[])tokens, (String)" ").trim();
    }

    private boolean collectionIsAllStrings(Object collection) {
        if (collection instanceof Collection) {
            return ((Collection)collection).stream().allMatch(o -> o instanceof String);
        }
        return false;
    }

    private void amendToList(Map<String, Object> map, String key, Object value) {
        Object element = map.get(key);
        if (element == null) {
            map.put(key, value);
        } else if (element instanceof List) {
            ((List)element).add(value);
        } else {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(element);
            list.add(value);
            map.put(key, list);
        }
    }

    @Procedure(mode=Mode.WRITE, value="apoc.xml.import")
    public Stream<NodeResult> importToGraph(@Name(value="url") String url, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException, XMLStreamException {
        XMLStreamReader xml = this.getXMLStreamReaderFromUrl(url);
        XmlImportConfig importConfig = new XmlImportConfig(config);
        ArrayDeque<ParentAndChildPair> parents = new ArrayDeque<ParentAndChildPair>();
        Node root = this.db.createNode(new Label[]{Label.label((String)"XmlDocument")});
        this.setPropertyIfNotNull(root, "_xmlVersion", xml.getVersion());
        this.setPropertyIfNotNull(root, "_xmlEncoding", xml.getEncoding());
        root.setProperty("url", (Object)url);
        parents.push(new ParentAndChildPair(root));
        Node last = root;
        Node lastWord = root;
        block9: while (xml.hasNext()) {
            xml.next();
            switch (xml.getEventType()) {
                case 7: {
                    continue block9;
                }
                case 3: {
                    Node pi = this.db.createNode(new Label[]{Label.label((String)"XmlProcessingInstruction")});
                    pi.setProperty("_piData", (Object)xml.getPIData());
                    pi.setProperty("_piTarget", (Object)xml.getPITarget());
                    last = this.connectWithParent(pi, (ParentAndChildPair)parents.peek(), last);
                    continue block9;
                }
                case 1: {
                    QName qName = xml.getName();
                    Node tag = this.db.createNode(new Label[]{Label.label((String)"XmlTag")});
                    tag.setProperty("_name", (Object)qName.getLocalPart());
                    for (int i = 0; i < xml.getAttributeCount(); ++i) {
                        tag.setProperty(xml.getAttributeLocalName(i), (Object)xml.getAttributeValue(i));
                    }
                    last = this.connectWithParent(tag, (ParentAndChildPair)parents.peek(), last);
                    parents.push(new ParentAndChildPair(tag));
                    continue block9;
                }
                case 4: {
                    String text = xml.getText().trim();
                    String[] words = text.split("\\s");
                    for (int i = 0; i < words.length; ++i) {
                        String currentWord = words[i];
                        if (currentWord.isEmpty()) continue;
                        Node word = this.db.createNode(new Label[]{Label.label((String)"XmlWord")});
                        word.setProperty("text", (Object)currentWord);
                        last = this.connectWithParent(word, (ParentAndChildPair)parents.peek(), last);
                        if (!importConfig.isCreateNextWordRelationship()) continue;
                        lastWord.createRelationshipTo(word, RelationshipType.withName((String)"NEXT_WORD"));
                        lastWord = word;
                    }
                    continue block9;
                }
                case 2: {
                    ParentAndChildPair parent = (ParentAndChildPair)parents.pop();
                    if (parent.getPreviousChild() == null) continue block9;
                    parent.getPreviousChild().createRelationshipTo(parent.getParent(), RelationshipType.withName((String)"LAST_CHILD_OF"));
                    continue block9;
                }
                case 8: {
                    parents.pop();
                    continue block9;
                }
                case 5: 
                case 6: {
                    continue block9;
                }
            }
            this.log.warn("xml file contains a {} type structure - ignoring this.", new Object[]{xml.getEventType()});
        }
        if (!parents.isEmpty()) {
            throw new IllegalStateException("non empty parents");
        }
        return Stream.of(new NodeResult(root));
    }

    private void setPropertyIfNotNull(Node root, String propertyKey, Object value) {
        if (value != null) {
            root.setProperty(propertyKey, value);
        }
    }

    private Node connectWithParent(Node thisNode, ParentAndChildPair parentAndChildPair, Node last) {
        Node parent = parentAndChildPair.getParent();
        Node previousChild = parentAndChildPair.getPreviousChild();
        last.createRelationshipTo(thisNode, RelationshipType.withName((String)"NEXT"));
        thisNode.createRelationshipTo(parent, RelationshipType.withName((String)"IS_CHILD_OF"));
        if (previousChild == null) {
            thisNode.createRelationshipTo(parent, RelationshipType.withName((String)"FIRST_CHILD_OF"));
        } else {
            previousChild.createRelationshipTo(thisNode, RelationshipType.withName((String)"NEXT_SIBLING"));
        }
        parentAndChildPair.setPreviousChild(thisNode);
        last = thisNode;
        return last;
    }

    private static class XmlImportConfig {
        private boolean createNextWordRelationship = false;

        public boolean isCreateNextWordRelationship() {
            return this.createNextWordRelationship;
        }

        public XmlImportConfig(Map<String, Object> config) {
            Boolean _createNextWordRelationship = (Boolean)config.get("createNextWordRelationships");
            if (_createNextWordRelationship != null) {
                this.createNextWordRelationship = _createNextWordRelationship;
            }
        }
    }

    public static class ParentAndChildPair {
        private Node parent;
        private Node previousChild = null;

        public ParentAndChildPair(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getPreviousChild() {
            return this.previousChild;
        }

        public void setPreviousChild(Node previousChild) {
            this.previousChild = previousChild;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParentAndChildPair that = (ParentAndChildPair)o;
            return this.parent.equals(that.parent);
        }

        public int hashCode() {
            return this.parent.hashCode();
        }
    }
}

