/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.result.LongResult;
import apoc.result.MapResult;
import apoc.util.MissingDependencyException;
import apoc.util.UrlResolver;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class MongoDB {
    @Procedure
    @Description(value="apoc.mongodb.get(host-or-port,db-or-null,collection-or-null,query-or-null,[compatibleValues=true|false],skip-or-null,limit-or-null) yield value - perform a find operation on mongodb collection")
    public Stream<MapResult> get(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="compatibleValues", defaultValue="false") boolean compatibleValues, @Name(value="skip", defaultValue="0") Long skip, @Name(value="limit", defaultValue="0") Long limit) {
        return this.getMongoColl(hostOrKey, db, collection, compatibleValues).all(query, skip, limit).map(MapResult::new);
    }

    @Procedure
    @Description(value="apoc.mongodb.count(host-or-port,db-or-null,collection-or-null,query-or-null) yield value - perform a find operation on mongodb collection")
    public Stream<LongResult> count(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query) {
        long count = this.getMongoColl(hostOrKey, db, collection, false).count(query);
        return Stream.of(new LongResult(count));
    }

    private Coll getColl(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, boolean compatibleValues) {
        String url = this.getMongoDBUrl(hostOrKey);
        return Coll.Factory.create(url, db, collection, compatibleValues);
    }

    @Procedure
    @Description(value="apoc.mongodb.first(host-or-port,db-or-null,collection-or-null,query-or-null,[compatibleValues=true|false]) yield value - perform a first operation on mongodb collection")
    public Stream<MapResult> first(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="compatibleValues", defaultValue="false") boolean compatibleValues) {
        Map<String, Object> result = this.getMongoColl(hostOrKey, db, collection, compatibleValues).first(query);
        return Stream.of(new MapResult(result));
    }

    @Procedure
    @Description(value="apoc.mongodb.find(host-or-port,db-or-null,collection-or-null,query-or-null,projection-or-null,sort-or-null,pagination,[compatibleValues=true|false],skip-or-null,limit-or-null) yield value - perform a find,project,sort operation on mongodb collection")
    public Stream<MapResult> find(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="project") Map<String, Object> project, @Name(value="sort") Map<String, Object> sort, @Name(value="compatibleValues", defaultValue="false") boolean compatibleValues, @Name(value="skip", defaultValue="0") Long skip, @Name(value="limit", defaultValue="0") Long limit) {
        return this.getMongoColl(hostOrKey, db, collection, compatibleValues).find(query, project, sort, skip, limit).map(MapResult::new);
    }

    @Procedure
    @Description(value="apoc.mongodb.insert(host-or-port,db-or-null,collection-or-null,list-of-maps) - inserts the given documents into the mongodb collection")
    public void insert(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="documents") List<Map<String, Object>> documents) {
        this.getMongoColl(hostOrKey, db, collection, false).insert(documents);
    }

    @Procedure
    @Description(value="apoc.mongodb.delete(host-or-port,db-or-null,collection-or-null,list-of-maps) - inserts the given documents into the mongodb collection")
    public Stream<LongResult> delete(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query) {
        return Stream.of(new LongResult(this.getMongoColl(hostOrKey, db, collection, false).delete(query)));
    }

    @Procedure
    @Description(value="apoc.mongodb.update(host-or-port,db-or-null,collection-or-null,list-of-maps) - inserts the given documents into the mongodb collection")
    public Stream<LongResult> update(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="update") Map<String, Object> update) {
        return Stream.of(new LongResult(this.getMongoColl(hostOrKey, db, collection, false).update(query, update)));
    }

    private String getMongoDBUrl(String hostOrKey) {
        return new UrlResolver("mongodb", "localhost", 27017).getUrl("mongodb", hostOrKey);
    }

    private Coll getMongoColl(String hostOrKey, String db, String collection, boolean compatibleValues) {
        Coll coll = null;
        try {
            coll = this.getColl(hostOrKey, db, collection, compatibleValues);
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException("Cannot find the jar into the plugins folder. \nPlease put these jar in the plugins folder :\n\nbson-x.y.z.jar\n\nmongo-java-driver-x.y.z.jar\n\nmongodb-driver-x.y.z.jar\n\nmongodb-driver-core-x.y.z.jar\n\njackson-annotations-x.y.z.jar\n\njackson-core-x.y.z.jar\n\njackson-databind-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_interacting_with_mongodb");
        }
        return coll;
    }

    static interface Coll
    extends Closeable {
        public Map<String, Object> first(Map<String, Object> var1);

        public Stream<Map<String, Object>> all(Map<String, Object> var1, Long var2, Long var3);

        public long count(Map<String, Object> var1);

        public Stream<Map<String, Object>> find(Map<String, Object> var1, Map<String, Object> var2, Map<String, Object> var3, Long var4, Long var5);

        public void insert(List<Map<String, Object>> var1);

        public long update(Map<String, Object> var1, Map<String, Object> var2);

        public long delete(Map<String, Object> var1);

        public static class Factory {
            public static Coll create(String url, String db, String coll, boolean compatibleValues) {
                try {
                    System.out.println(String.format("%s %s %s %s", url, db, coll, compatibleValues));
                    return (Coll)Class.forName("apoc.mongodb.MongoDBColl").getConstructor(String.class, String.class, String.class, Boolean.class).newInstance(url, db, coll, compatibleValues);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not create MongoDBClientWrapper instance", e);
                }
            }
        }
    }
}

