/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.mongodb.MongoDB;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDBColl
implements MongoDB.Coll {
    private static final ObjectMapper jsonMapper = new ObjectMapper().enable(DeserializationFeature.USE_LONG_FOR_INTS);
    private MongoCollection<Document> collection;
    private MongoClient mongoClient;
    private boolean compatibleValues = false;

    public MongoDBColl(String url, String db, String coll) {
        MongoClientURI connectionString = new MongoClientURI(url);
        this.mongoClient = new MongoClient(connectionString);
        MongoDatabase database = this.mongoClient.getDatabase(db);
        this.collection = database.getCollection(coll);
    }

    public MongoDBColl(String url, String db, String coll, Boolean compatibleValues) {
        this(url, db, coll);
        this.compatibleValues = compatibleValues;
    }

    @Override
    public void close() throws IOException {
        this.mongoClient.close();
    }

    private Map<String, Object> documentToPackableMap(Map<String, Object> document) {
        Object objectId;
        if (this.compatibleValues) {
            try {
                return (Map)jsonMapper.readValue(jsonMapper.writeValueAsBytes(document), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot convert document to json and back to Map " + e.getMessage());
            }
        }
        if (document != null && (objectId = document.get("_id")) != null) {
            document.put("_id", objectId.toString());
        }
        return document;
    }

    @Override
    public Map<String, Object> first(Map<String, Object> query) {
        return this.documentToPackableMap((Map)this.collection.find((Bson)new Document(query)).first());
    }

    @Override
    public Stream<Map<String, Object>> all(Map<String, Object> query, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((FindIterable<Document>)documents);
    }

    @Override
    public long count(Map<String, Object> query) {
        return query == null ? this.collection.count() : this.collection.count((Bson)new Document(query));
    }

    private Stream<Map<String, Object>> asStream(FindIterable<Document> result) {
        MongoCursor iterator = result.iterator();
        Spliterator spliterator = Spliterators.spliterator(iterator, -1L, 16);
        return (Stream)StreamSupport.stream(spliterator, false).map(doc -> this.documentToPackableMap((Map<String, Object>)doc)).onClose(() -> ((MongoCursor)iterator).close());
    }

    @Override
    public Stream<Map<String, Object>> find(Map<String, Object> query, Map<String, Object> project, Map<String, Object> sort, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (project != null) {
            documents = documents.projection((Bson)new Document(project));
        }
        if (sort != null) {
            documents = documents.sort((Bson)new Document(sort));
        }
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((FindIterable<Document>)documents);
    }

    @Override
    public void insert(List<Map<String, Object>> docs) {
        for (Map<String, Object> doc : docs) {
            this.collection.insertOne((Object)new Document(doc));
        }
    }

    @Override
    public long update(Map<String, Object> query, Map<String, Object> update) {
        UpdateResult updateResult = this.collection.updateMany((Bson)new Document(query), (Bson)new Document(update));
        return updateResult.wasAcknowledged() ? updateResult.getModifiedCount() : -updateResult.getModifiedCount();
    }

    @Override
    public long delete(Map<String, Object> query) {
        DeleteResult result = this.collection.deleteMany((Bson)new Document(query));
        return result.wasAcknowledged() ? result.getDeletedCount() : -result.getDeletedCount();
    }
}

