/*
 * Decompiled with CFR 0.152.
 */
package apoc.monitor;

import apoc.result.KernelInfoResult;
import java.util.Date;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

public class Kernel {
    private static final String JMX_OBJECT_NAME = "Kernel";
    private static final String READ_ONLY = "ReadOnly";
    private static final String KERNEL_VERSION = "KernelVersion";
    private static final String STORE_ID = "StoreId";
    private static final String START_TIME = "KernelStartTime";
    private static final String DB_NAME = "DatabaseName";
    private static final String STORE_LOG_VERSION = "StoreLogVersion";
    private static final String STORE_CREATION_DATE = "StoreCreationDate";
    @Context
    public GraphDatabaseService database;

    @Procedure
    @Description(value="apoc.monitor.kernel() returns informations about the neo4j kernel")
    public Stream<KernelInfoResult> kernel() {
        ObjectName objectName = JmxUtils.getObjectName((GraphDatabaseService)this.database, (String)JMX_OBJECT_NAME);
        KernelInfoResult info = new KernelInfoResult((Boolean)JmxUtils.getAttribute((ObjectName)objectName, (String)READ_ONLY), (String)JmxUtils.getAttribute((ObjectName)objectName, (String)KERNEL_VERSION), (String)JmxUtils.getAttribute((ObjectName)objectName, (String)STORE_ID), (Date)JmxUtils.getAttribute((ObjectName)objectName, (String)START_TIME), (String)JmxUtils.getAttribute((ObjectName)objectName, (String)DB_NAME), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)STORE_LOG_VERSION), (Date)JmxUtils.getAttribute((ObjectName)objectName, (String)STORE_CREATION_DATE));
        return Stream.of(info);
    }
}

