/*
 * Decompiled with CFR 0.152.
 */
package apoc.monitor;

import apoc.result.StoreInfoResult;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

public class Store {
    private static final String JMX_OBJECT_NAME = "Store file sizes";
    private static final String LOG_SIZE = "LogicalLogSize";
    private static final String STRING_SIZE = "StringStoreSize";
    private static final String ARRAY_SIZE = "ArrayStoreSize";
    private static final String REL_SIZE = "RelationshipStoreSize";
    private static final String PROP_SIZE = "PropertyStoreSize";
    private static final String TOTAL_SIZE = "TotalStoreSize";
    private static final String NODE_SIZE = "NodeStoreSize";
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.monitor.store() returns informations about the sizes of the different parts of the neo4j graph store")
    public Stream<StoreInfoResult> store() {
        ObjectName objectName = JmxUtils.getObjectName((GraphDatabaseService)this.db, (String)JMX_OBJECT_NAME);
        StoreInfoResult storeInfo = new StoreInfoResult((Long)JmxUtils.getAttribute((ObjectName)objectName, (String)LOG_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)STRING_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)ARRAY_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)REL_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)PROP_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)TOTAL_SIZE), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)NODE_SIZE));
        return Stream.of(storeInfo);
    }
}

