/*
 * Decompiled with CFR 0.152.
 */
package apoc.monitor;

import apoc.result.TransactionInfoResult;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

public class Transaction {
    private static final String JMX_OBJECT_NAME = "Transactions";
    private static final String ROLLED_BACK_TX = "NumberOfRolledBackTransactions";
    private static final String PEAK_TX = "PeakNumberOfConcurrentTransactions";
    private static final String LAST_TX_ID = "LastCommittedTxId";
    private static final String OPEN_TX = "NumberOfOpenTransactions";
    private static final String OPENED_TX = "NumberOfOpenedTransactions";
    private static final String COMMITTED_TX = "NumberOfCommittedTransactions";
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.monitor.tx() returns informations about the neo4j transaction manager")
    public Stream<TransactionInfoResult> tx() throws Exception {
        return Stream.of(this.getTransactionInfo());
    }

    private TransactionInfoResult getTransactionInfo() throws Exception {
        ObjectName objectName = JmxUtils.getObjectName((GraphDatabaseService)this.db, (String)JMX_OBJECT_NAME);
        return new TransactionInfoResult((Long)JmxUtils.getAttribute((ObjectName)objectName, (String)ROLLED_BACK_TX), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)PEAK_TX), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)LAST_TX_ID), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)OPEN_TX), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)OPENED_TX), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)COMMITTED_TX));
    }
}

