/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.path.LabelMatcher;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.Evaluation;

public class LabelMatcherGroup {
    private boolean endNodesOnly;
    private LabelMatcher whitelistMatcher = new LabelMatcher();
    private LabelMatcher blacklistMatcher = new LabelMatcher();
    private LabelMatcher endNodeMatcher = new LabelMatcher();
    private LabelMatcher terminatorNodeMatcher = new LabelMatcher();

    public LabelMatcherGroup addLabels(String fullFilterString) {
        if (fullFilterString != null && !fullFilterString.isEmpty()) {
            String[] elements;
            for (String filterString : elements = fullFilterString.split("\\|")) {
                this.addLabel(filterString);
            }
        }
        return this;
    }

    public LabelMatcherGroup addLabel(String filterString) {
        if (filterString != null && !filterString.isEmpty()) {
            LabelMatcher matcher;
            char operator = filterString.charAt(0);
            switch (operator) {
                case '>': {
                    this.endNodesOnly = true;
                    matcher = this.endNodeMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '/': {
                    this.endNodesOnly = true;
                    matcher = this.terminatorNodeMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '-': {
                    matcher = this.blacklistMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '+': {
                    filterString = filterString.substring(1);
                }
                default: {
                    matcher = this.whitelistMatcher;
                }
            }
            matcher.addLabel(filterString);
        }
        return this;
    }

    public Evaluation evaluate(Node node, boolean belowMinLevel) {
        if (this.blacklistMatcher.matchesLabels(node)) {
            return Evaluation.EXCLUDE_AND_PRUNE;
        }
        if (this.terminatorNodeMatcher.matchesLabels(node)) {
            return belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_PRUNE;
        }
        if (this.endNodeMatcher.matchesLabels(node)) {
            return belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
        if (this.whitelistMatcher.isEmpty() || this.whitelistMatcher.matchesLabels(node)) {
            return this.endNodesOnly || belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
        return Evaluation.EXCLUDE_AND_PRUNE;
    }

    public boolean isEndNodesOnly() {
        return this.endNodesOnly;
    }

    public void setEndNodesOnly(boolean endNodesOnly) {
        this.endNodesOnly = endNodesOnly;
    }
}

