/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PathEvaluator;

public final class NodeEvaluators {
    private NodeEvaluators() {
    }

    public static Evaluator endAndTerminatorNodeEvaluator(List<Node> endNodes, List<Node> terminatorNodes) {
        Node[] nodes;
        PathEvaluator endNodeEvaluator = null;
        PathEvaluator terminatorNodeEvaluator = null;
        if (!endNodes.isEmpty()) {
            nodes = endNodes.toArray(new Node[endNodes.size()]);
            endNodeEvaluator = Evaluators.includeWhereEndNodeIs((Node[])nodes);
        }
        if (!terminatorNodes.isEmpty()) {
            nodes = terminatorNodes.toArray(new Node[terminatorNodes.size()]);
            terminatorNodeEvaluator = Evaluators.pruneWhereEndNodeIs((Node[])nodes);
        }
        if (endNodeEvaluator != null || terminatorNodeEvaluator != null) {
            return new EndAndTerminatorNodeEvaluator((Evaluator)endNodeEvaluator, (Evaluator)terminatorNodeEvaluator);
        }
        return null;
    }

    public static Evaluator whitelistNodeEvaluator(List<Node> whitelistNodes) {
        return new WhitelistNodeEvaluator(whitelistNodes);
    }

    public static Evaluator blacklistNodeEvaluator(List<Node> blacklistNodes) {
        return new BlacklistNodeEvaluator(blacklistNodes);
    }

    private static class WhitelistNodeEvaluator
    implements Evaluator {
        private Set<Node> whitelistSet;

        public WhitelistNodeEvaluator(List<Node> whitelistNodes) {
            this.whitelistSet = new HashSet<Node>(whitelistNodes);
        }

        public Evaluation evaluate(Path path) {
            return this.whitelistSet.contains(path.endNode()) ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_PRUNE;
        }
    }

    private static class BlacklistNodeEvaluator
    implements Evaluator {
        private Set<Node> blacklistSet;

        public BlacklistNodeEvaluator(List<Node> blacklistNodes) {
            this.blacklistSet = new HashSet<Node>(blacklistNodes);
        }

        public Evaluation evaluate(Path path) {
            return this.blacklistSet.contains(path.endNode()) ? Evaluation.EXCLUDE_AND_PRUNE : Evaluation.INCLUDE_AND_CONTINUE;
        }
    }

    private static class EndAndTerminatorNodeEvaluator
    implements Evaluator {
        private Evaluator endNodeEvaluator;
        private Evaluator terminatorNodeEvaluator;

        public EndAndTerminatorNodeEvaluator(Evaluator endNodeEvaluator, Evaluator terminatorNodeEvaluator) {
            this.endNodeEvaluator = endNodeEvaluator;
            this.terminatorNodeEvaluator = terminatorNodeEvaluator;
        }

        public Evaluation evaluate(Path path) {
            boolean includes = this.evalIncludes(this.endNodeEvaluator, path) || this.evalIncludes(this.terminatorNodeEvaluator, path);
            boolean continues = this.terminatorNodeEvaluator == null || this.terminatorNodeEvaluator.evaluate(path).continues();
            return Evaluation.of((boolean)includes, (boolean)continues);
        }

        private boolean evalIncludes(Evaluator eval, Path path) {
            return eval != null && eval.evaluate(path).includes();
        }
    }
}

