/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Pair;

public abstract class RelationshipTypeAndDirections {
    public static final char BACKTICK = '`';

    public static List<Pair<RelationshipType, Direction>> parse(String pathFilter) {
        ArrayList<Pair<RelationshipType, Direction>> relsAndDirs = new ArrayList<Pair<RelationshipType, Direction>>();
        if (pathFilter == null) {
            relsAndDirs.add(Pair.of(null, (Object)Direction.BOTH));
        } else {
            String[] defs;
            for (String def : defs = pathFilter.split("\\|")) {
                relsAndDirs.add((Pair<RelationshipType, Direction>)Pair.of((Object)RelationshipTypeAndDirections.relationshipTypeFor(def), (Object)RelationshipTypeAndDirections.directionFor(def)));
            }
        }
        return relsAndDirs;
    }

    private static Direction directionFor(String type) {
        if (type.contains("<")) {
            return Direction.INCOMING;
        }
        if (type.contains(">")) {
            return Direction.OUTGOING;
        }
        return Direction.BOTH;
    }

    private static RelationshipType relationshipTypeFor(String name) {
        name = name.indexOf(96) > -1 ? name.substring(name.indexOf(96) + 1, name.lastIndexOf(96)) : name.replaceAll("[<>:]", "");
        return name.trim().isEmpty() ? null : RelationshipType.withName((String)name);
    }
}

