/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import apoc.result.AssertSchemaResult;
import apoc.result.ConstraintRelationshipInfo;
import apoc.result.IndexConstraintNodeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Schemas {
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction tx;

    @Procedure(value="apoc.schema.assert", mode=Mode.SCHEMA)
    @Description(value="apoc.schema.assert({indexLabel:[[indexKeys]], ...}, {constraintLabel:[constraintKeys], ...}, dropExisting : true) yield label, key, keys, unique, action - drops all other existing indexes and constraints when `dropExisting` is `true` (default is `true`), and asserts that at the end of the operation the given indexes and unique constraints are there, each label:key pair is considered one constraint/label. Non-constraint indexes can define compound indexes with label:[key1,key2...] pairings.")
    public Stream<AssertSchemaResult> schemaAssert(@Name(value="indexes") Map<String, List<Object>> indexes, @Name(value="constraints") Map<String, List<String>> constraints, @Name(value="dropExisting", defaultValue="true") boolean dropExisting) throws ExecutionException, InterruptedException {
        return Stream.concat(this.assertIndexes(indexes, dropExisting).stream(), this.assertConstraints(constraints, dropExisting).stream());
    }

    @Procedure(value="apoc.schema.nodes", mode=Mode.SCHEMA)
    @Description(value="CALL apoc.schema.nodes() yield name, label, properties, status, type")
    public Stream<IndexConstraintNodeInfo> nodes() throws IndexNotFoundKernelException {
        return this.indexesAndConstraintsForNode();
    }

    @Procedure(value="apoc.schema.relationships", mode=Mode.SCHEMA)
    @Description(value="CALL apoc.schema.relationships() yield name, startLabel, type, endLabel, properties, status")
    public Stream<ConstraintRelationshipInfo> relationships() {
        return this.constraintsForRelationship();
    }

    @UserFunction(value="apoc.schema.node.indexExists")
    @Description(value="RETURN apoc.schema.node.indexExists(labelName, propertyNames)")
    public Boolean indexExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.indexExists(labelName, propertyNames);
    }

    @UserFunction(value="apoc.schema.node.constraintExists")
    @Description(value="RETURN apoc.schema.node.constraintExists(labelName, propertyNames)")
    public Boolean constraintExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExists(labelName, propertyNames);
    }

    @UserFunction(value="apoc.schema.relationship.constraintExists")
    @Description(value="RETURN apoc.schema.relationship.constraintExists(type, propertyNames)")
    public Boolean constraintExistsOnRelationship(@Name(value="type") String type, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExistsForRelationship(type, propertyNames);
    }

    public List<AssertSchemaResult> assertConstraints(Map<String, List<String>> constraints0, boolean dropExisting) throws ExecutionException, InterruptedException {
        Map<String, List<String>> constraints = this.copy(constraints0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(constraints.size());
        Schema schema = this.db.schema();
        for (ConstraintDefinition constraintDefinition : schema.getConstraints()) {
            if (!constraintDefinition.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            String label = constraintDefinition.getLabel().name();
            String key = (String)Iterables.single((Iterable)constraintDefinition.getPropertyKeys());
            AssertSchemaResult info = new AssertSchemaResult(label, key).unique();
            if (!(constraints.containsKey(label) && constraints.get(label).remove(key) || !dropExisting)) {
                constraintDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : constraints.entrySet()) {
            for (String key : (List)entry.getValue()) {
                schema.constraintFor(Label.label((String)((String)entry.getKey()))).assertPropertyIsUnique(key).create();
                result.add(new AssertSchemaResult((String)entry.getKey(), key).unique().created());
            }
        }
        return result;
    }

    public List<AssertSchemaResult> assertIndexes(Map<String, List<Object>> indexes0, boolean dropExisting) throws ExecutionException, InterruptedException, IllegalArgumentException {
        Schema schema = this.db.schema();
        Map<String, List<Object>> indexes = this.copyMapOfObjects(indexes0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(indexes.size());
        for (IndexDefinition indexDefinition : schema.getIndexes()) {
            if (indexDefinition.isConstraintIndex()) continue;
            String label = indexDefinition.getLabel().name();
            ArrayList<String> keys = new ArrayList<String>();
            indexDefinition.getPropertyKeys().forEach(keys::add);
            AssertSchemaResult info = new AssertSchemaResult(label, keys);
            if (indexes.containsKey(label)) {
                if (keys.size() > 1) {
                    indexes.get(label).remove(keys);
                } else if (keys.size() == 1) {
                    indexes.get(label).remove(keys.get(0));
                } else {
                    throw new IllegalArgumentException("Label given with no keys.");
                }
            }
            if (dropExisting) {
                indexDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        if (dropExisting) {
            indexes = this.copyMapOfObjects(indexes0);
        }
        for (Map.Entry entry : indexes.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createSinglePropertyIndex(schema, (String)entry.getKey(), (String)key));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createCompoundIndex((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private AssertSchemaResult createSinglePropertyIndex(Schema schema, String lbl, String key) {
        schema.indexFor(Label.label((String)lbl)).on(key).create();
        return new AssertSchemaResult(lbl, key).created();
    }

    private AssertSchemaResult createCompoundIndex(String label, List<String> keys) {
        ArrayList backTickedKeys = new ArrayList();
        keys.forEach(key -> backTickedKeys.add(String.format("`%s`", key)));
        this.db.execute(String.format("CREATE INDEX ON :`%s` (%s)", label, String.join((CharSequence)",", backTickedKeys)));
        return new AssertSchemaResult(label, keys).created();
    }

    private Map<String, List<Object>> copyMapOfObjects(Map<String, List<Object>> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(input.size());
        input.forEach((k, v) -> {
            List cfr_ignored_0 = result.put((String)k, new ArrayList(v));
        });
        return result;
    }

    private Map<String, List<String>> copy(Map<String, List<String>> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(input.size());
        input.forEach((k, v) -> {
            List cfr_ignored_0 = result.put((String)k, new ArrayList(v));
        });
        return result;
    }

    private Boolean indexExists(String labelName, List<String> propertyNames) {
        Schema schema = this.db.schema();
        for (IndexDefinition indexDefinition : Iterables.asList((Iterable)schema.getIndexes(Label.label((String)labelName)))) {
            List properties = Iterables.asList((Iterable)indexDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExists(String labelName, List<String> propertyNames) {
        Schema schema = this.db.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList((Iterable)schema.getConstraints(Label.label((String)labelName)))) {
            List properties = Iterables.asList((Iterable)constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExistsForRelationship(String type, List<String> propertyNames) {
        Schema schema = this.db.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList((Iterable)schema.getConstraints(RelationshipType.withName((String)type)))) {
            List properties = Iterables.asList((Iterable)constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Stream<IndexConstraintNodeInfo> indexesAndConstraintsForNode() throws IndexNotFoundKernelException {
        Schema schema = this.db.schema();
        try (Statement ignore = this.tx.acquireStatement();){
            TokenRead tokenRead = this.tx.tokenRead();
            SilentTokenNameLookup tokens = new SilentTokenNameLookup(tokenRead);
            SchemaRead schemaRead = this.tx.schemaRead();
            Iterable indexesIterator = () -> schemaRead.indexesGetAll();
            Stream<IndexConstraintNodeInfo> stream = StreamSupport.stream(indexesIterator.spliterator(), false).map(arg_0 -> this.lambda$indexesAndConstraintsForNode$4(schemaRead, (TokenNameLookup)tokens, arg_0)).sorted(Comparator.comparing(i -> i.label));
            return stream;
        }
    }

    private Stream<ConstraintRelationshipInfo> constraintsForRelationship() {
        Schema schema = this.db.schema();
        return StreamSupport.stream(schema.getConstraints().spliterator(), false).filter(constraintDefinition -> constraintDefinition.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)).map(this::relationshipInfoFromConstraintDefinition);
    }

    private IndexConstraintNodeInfo nodeInfoFromIndexDefinition(IndexReference indexReference, SchemaRead schemaRead, TokenNameLookup tokens) {
        String labelName = tokens.labelGetName(indexReference.label());
        ArrayList<String> properties = new ArrayList<String>();
        Arrays.stream(indexReference.properties()).forEach(i -> properties.add(tokens.propertyKeyGetName(i)));
        try {
            return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, (String)",")), labelName, properties, schemaRead.indexGetState(indexReference).toString(), !indexReference.isUnique() ? "INDEX" : "UNIQUENESS", schemaRead.indexGetState(indexReference).equals((Object)InternalIndexState.FAILED) ? schemaRead.indexGetFailure(indexReference) : "NO FAILURE", schemaRead.indexGetPopulationProgress(indexReference).getCompleted() / schemaRead.indexGetPopulationProgress(indexReference).getTotal() * 100L, schemaRead.indexSize(indexReference), schemaRead.indexUniqueValuesSelectivity(indexReference), indexReference.userDescription(tokens));
        }
        catch (IndexNotFoundKernelException e) {
            return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, (String)",")), labelName, properties, "NOT_FOUND", !indexReference.isUnique() ? "INDEX" : "UNIQUENESS", "NOT_FOUND", 0.0f, 0L, 0.0, indexReference.userDescription(tokens));
        }
    }

    private ConstraintRelationshipInfo relationshipInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition) {
        return new ConstraintRelationshipInfo(String.format("CONSTRAINT %s", constraintDefinition.toString()), constraintDefinition.getConstraintType().name(), Iterables.asList((Iterable)constraintDefinition.getPropertyKeys()), "");
    }

    private /* synthetic */ IndexConstraintNodeInfo lambda$indexesAndConstraintsForNode$4(SchemaRead schemaRead, TokenNameLookup tokens, IndexReference indexReference) {
        return this.nodeInfoFromIndexDefinition(indexReference, schemaRead, tokens);
    }
}

