/*
 * Decompiled with CFR 0.152.
 */
package apoc.scoring;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Scoring {
    @UserFunction
    @Description(value="apoc.scoring.existence(5, true) returns the provided score if true, 0 if false")
    public double existence(@Name(value="score") long score, @Name(value="exists") boolean exists) {
        return exists ? score : 0L;
    }

    @UserFunction
    @Description(value="apoc.scoring.pareto(10, 20, 100, 11) applies a Pareto scoring function over the inputs")
    public double pareto(@Name(value="minimumThreshold") long minimumThreshold, @Name(value="eightyPercentValue") long eightyPercentValue, @Name(value="maximumValue") long maximumValue, @Name(value="score") long score) {
        if (score < minimumThreshold) {
            return 0.0;
        }
        double alpha = Math.log(5.0) / (double)eightyPercentValue;
        double exp = Math.exp(-alpha * (double)score);
        return (double)maximumValue * (1.0 - exp);
    }
}

