/*
 * Decompiled with CFR 0.152.
 */
package apoc.text;

import apoc.result.StringResult;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Soundex;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Phonetic {
    private static final DoubleMetaphone DOUBLE_METAPHONE = new DoubleMetaphone();

    @Procedure
    @Description(value="apoc.text.phonetic(value) yield value - Compute the US_ENGLISH phonetic soundex encoding of all words of the text value which can be a single string or a list of strings")
    public Stream<StringResult> phonetic(@Name(value="value") Object value) {
        Stream<Object> stream = value instanceof Iterable ? StreamSupport.stream(((Iterable)value).spliterator(), false) : Stream.of(value);
        return stream.map(str -> str == null ? StringResult.EMPTY : new StringResult(Stream.of(str.toString().split("\\W+")).map(arg_0 -> ((Soundex)Soundex.US_ENGLISH).soundex(arg_0)).reduce("", (a, s) -> a + s)));
    }

    @Procedure
    @Description(value="apoc.text.phoneticDelta(text1, text2) yield phonetic1, phonetic2, delta - Compute the US_ENGLISH soundex character difference between two given strings")
    public Stream<PhoneticResult> phoneticDelta(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        try {
            return Stream.of(new PhoneticResult(Soundex.US_ENGLISH.soundex(text1), Soundex.US_ENGLISH.soundex(text2), Soundex.US_ENGLISH.difference(text1, text2)));
        }
        catch (EncoderException e) {
            throw new RuntimeException("Error encoding text " + text1 + " or " + text2 + " for delta measure", e);
        }
    }

    @Procedure
    @Description(value="apoc.text.doubleMetaphone(value) yield value - Compute the Double Metaphone phonetic encoding of all words of the text value which can be a single string or a list of strings")
    public Stream<StringResult> doubleMetaphone(@Name(value="value") Object value) {
        Stream<Object> stream = value instanceof Iterable ? StreamSupport.stream(((Iterable)value).spliterator(), false) : Stream.of(value);
        return stream.map(str -> str == null || str.toString().isEmpty() ? StringResult.EMPTY : new StringResult(Stream.of(str.toString().trim().split("\\W+")).map(arg_0 -> ((DoubleMetaphone)DOUBLE_METAPHONE).doubleMetaphone(arg_0)).reduce("", (a, s) -> a + s)));
    }

    public static class PhoneticResult {
        public final String phonetic1;
        public final String phonetic2;
        public final long delta;

        public PhoneticResult(String phonetic1, String phonetic2, Number delta) {
            this.phonetic1 = phonetic1;
            this.phonetic2 = phonetic2;
            this.delta = delta.longValue();
        }
    }
}

