/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfiguration;

public class UrlResolver {
    private final String defaultScheme;
    private final String defaultHost;
    private final int defaultPort;
    private final String defaultUrl;

    public UrlResolver(String defaultScheme, String defaultHost, int defaultPort) {
        this.defaultScheme = defaultScheme;
        this.defaultHost = defaultHost;
        this.defaultPort = defaultPort;
        this.defaultUrl = defaultScheme + "://" + defaultHost + ":" + defaultPort;
    }

    public String getUrl(String prefix, String hostOrKey) {
        String url = this.getConfiguredUrl(prefix, hostOrKey);
        if (url != null) {
            return url;
        }
        url = this.getConfiguredUrl(prefix, "");
        if (url != null) {
            return url;
        }
        url = this.resolveHost(hostOrKey);
        return url == null ? this.defaultUrl : url;
    }

    public String getConfiguredUrl(String prefix, String key) {
        String base = prefix + "." + key + (key == null || key.isEmpty() ? "" : ".");
        String url = ApocConfiguration.get(base + "url", null);
        if (url != null) {
            return url;
        }
        String host = ApocConfiguration.get(base + "host", null);
        return this.resolveHost(host);
    }

    public String resolveHost(String host) {
        if (host != null) {
            if (host.contains("//")) {
                return host;
            }
            if (host.contains(":")) {
                return this.defaultScheme + "://" + host;
            }
            return this.defaultScheme + "://" + host + ":" + this.defaultPort;
        }
        return null;
    }
}

