/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.kernel;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class MultiThreadedGlobalGraphOperations {
    public static BatchJobResult forAllNodes(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, BiConsumer<KernelTransaction, NodeCursor> consumer) {
        return MultiThreadedGlobalGraphOperations.forAll(db, executorService, batchSize, GlobalOperationsTypes.NODES, consumer);
    }

    public static BatchJobResult forAllRelationships(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, BiConsumer<KernelTransaction, RelationshipScanCursor> consumer) {
        return MultiThreadedGlobalGraphOperations.forAll(db, executorService, batchSize, GlobalOperationsTypes.RELATIONSHIPS, consumer);
    }

    private static BatchJobResult forAll(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, GlobalOperationsTypes type, BiConsumer consumer) {
        try {
            DependencyResolver dependencyResolver = db.getDependencyResolver();
            long maxId = MultiThreadedGlobalGraphOperations.getHighestIdInUseForStore(dependencyResolver, type);
            ThreadToStatementContextBridge ctx = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
            ArrayList<BatchJob> taskList = new ArrayList<BatchJob>();
            BatchJobResult result = new BatchJobResult();
            result.startStopWatch();
            for (long batchStart = 0L; batchStart < maxId; batchStart += (long)batchSize) {
                taskList.add(new BatchJob(type, batchStart, batchSize, db, ctx, consumer, result));
            }
            executorService.invokeAll(taskList);
            result.stopStopWatch();
            result.setBatches(taskList.size());
            return result;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getHighestIdInUseForStore(DependencyResolver dependencyResolver, GlobalOperationsTypes type) {
        NodeStore store;
        NeoStores neoStores = ((RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        switch (type) {
            case NODES: {
                store = neoStores.getNodeStore();
                break;
            }
            case RELATIONSHIPS: {
                store = neoStores.getRelationshipStore();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type " + (Object)((Object)type));
            }
        }
        return store.getHighId();
    }

    private static class BatchJob
    implements Callable<Void> {
        private final GlobalOperationsTypes type;
        private final long batchStart;
        private final int batchSize;
        private final GraphDatabaseAPI db;
        private final ThreadToStatementContextBridge ctx;
        private final BiConsumer consumer;
        private final BatchJobResult result;

        public BatchJob(GlobalOperationsTypes type, long batchStart, int batchSize, GraphDatabaseAPI db, ThreadToStatementContextBridge ctx, BiConsumer consumer, BatchJobResult result) {
            this.type = type;
            this.batchStart = batchStart;
            this.batchSize = batchSize;
            this.db = db;
            this.ctx = ctx;
            this.consumer = consumer;
            this.result = result;
        }

        @Override
        public Void call() {
            try (Transaction tx = this.db.beginTx();){
                KernelTransaction ktx = this.ctx.getKernelTransactionBoundToThisThread(true);
                CursorFactory cursors = ktx.cursors();
                Read read = ktx.dataRead();
                switch (this.type) {
                    case NODES: {
                        this.iterateForNodes(ktx, read, cursors, this.result);
                        break;
                    }
                    case RELATIONSHIPS: {
                        this.iterateForRelationships(ktx, read, cursors, this.result);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("dunno how to deal with type " + (Object)((Object)this.type));
                    }
                }
                tx.success();
                Void void_ = null;
                return void_;
            }
        }

        private void iterateForNodes(KernelTransaction ktx, Read read, CursorFactory cursors, BatchJobResult result) {
            try (NodeCursor cursor = cursors.allocateNodeCursor();){
                for (long id = this.batchStart; id < this.batchStart + (long)this.batchSize; ++id) {
                    read.singleNode(id, cursor);
                    this.processAndReport(ktx, () -> ((NodeCursor)cursor).next(), this.consumer, cursor, result);
                }
            }
        }

        private void iterateForRelationships(KernelTransaction ktx, Read read, CursorFactory cursors, BatchJobResult result) {
            try (RelationshipScanCursor cursor = cursors.allocateRelationshipScanCursor();){
                for (long id = this.batchStart; id < this.batchStart + (long)this.batchSize; ++id) {
                    read.singleRelationship(id, cursor);
                    this.processAndReport(ktx, () -> ((RelationshipScanCursor)cursor).next(), this.consumer, cursor, result);
                }
            }
        }

        private void processAndReport(KernelTransaction ktx, Supplier<Boolean> nextMethod, BiConsumer consumer, Object parameter, BatchJobResult result) {
            if (nextMethod.get().booleanValue()) {
                try {
                    consumer.accept(ktx, parameter);
                    result.incrementSuceeded();
                }
                catch (Exception e) {
                    result.incrementFailures();
                }
            } else {
                result.incrementMissing();
            }
        }
    }

    public static class BatchJobResult {
        final AtomicLong succeeded = new AtomicLong(0L);
        final AtomicLong missing = new AtomicLong(0L);
        final AtomicLong failures = new AtomicLong(0L);
        private long started;
        private long duration;
        private int batches;

        public void incrementSuceeded() {
            this.succeeded.incrementAndGet();
        }

        public void incrementMissing() {
            this.missing.incrementAndGet();
        }

        public void incrementFailures() {
            this.failures.incrementAndGet();
        }

        public long getSucceeded() {
            return this.succeeded.get();
        }

        public long getMissing() {
            return this.missing.get();
        }

        public long getFailures() {
            return this.failures.get();
        }

        public long getDuration() {
            return this.duration;
        }

        public void startStopWatch() {
            this.started = System.currentTimeMillis();
        }

        public void stopStopWatch() {
            this.duration = System.currentTimeMillis() - this.started;
        }

        public void setBatches(int batches) {
            this.batches = batches;
        }

        public int getBatches() {
            return this.batches;
        }
    }

    public static enum GlobalOperationsTypes {
        NODES,
        RELATIONSHIPS;

    }
}

