/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ExtendedApocGlobalComponents;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;

public class ExtendedRegisterComponentFactory
extends ExtensionFactory<Dependencies> {
    private Log log;
    private GlobalProcedures globalProceduresRegistry;

    public ExtendedRegisterComponentFactory() {
        super(ExtensionType.GLOBAL, "ApocRegisterComponentExtended");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        this.globalProceduresRegistry = dependencies.globalProceduresRegistry();
        this.log = dependencies.log().getUserLog(ExtendedRegisterComponentFactory.class);
        return new RegisterComponentLifecycle();
    }

    public class RegisterComponentLifecycle
    extends LifecycleAdapter {
        private final Map<Class, Map<String, Object>> resolvers = new ConcurrentHashMap<Class, Map<String, Object>>();

        public void addResolver(String databaseNamme, Class clazz, Object instance) {
            Map classInstanceMap = this.resolvers.computeIfAbsent(clazz, s -> new ConcurrentHashMap());
            classInstanceMap.put(databaseNamme, instance);
        }

        public Map<Class, Map<String, Object>> getResolvers() {
            return this.resolvers;
        }

        public void init() throws Exception {
            for (ExtendedApocGlobalComponents c : Services.loadAll(ExtendedApocGlobalComponents.class)) {
                for (Class clazz2 : c.getContextClasses()) {
                    this.resolvers.put(clazz2, new ConcurrentHashMap());
                }
            }
            this.resolvers.forEach((clazz, dbFunctionMap) -> ExtendedRegisterComponentFactory.this.globalProceduresRegistry.registerComponent(clazz, context -> {
                String databaseName = context.graphDatabaseAPI().databaseName();
                Object instance = dbFunctionMap.get(databaseName);
                if (instance == null) {
                    ExtendedRegisterComponentFactory.this.log.warn("couldn't find a instance for clazz %s and database %s", new Object[]{clazz.getName(), databaseName});
                }
                return instance;
            }, true));
        }
    }

    public static interface Dependencies {
        public LogService log();

        public GlobalProcedures globalProceduresRegistry();
    }
}

