/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class Median {
    @UserAggregationFunction(value="apoc.agg.median")
    @Description(value="apoc.agg.median(number) - returns median for non-null numeric values")
    public MedianFunction median() {
        return new MedianFunction();
    }

    public static class MedianFunction {
        private List<Double> values = new ArrayList<Double>();

        @UserAggregationUpdate
        public void aggregate(@Name(value="value") Object value) {
            if (value instanceof Number) {
                this.values.add(((Number)value).doubleValue());
            }
        }

        @UserAggregationResult
        public Object result() {
            if (this.values.isEmpty()) {
                return null;
            }
            Collections.sort(this.values);
            int size = this.values.size();
            if (size % 2 == 1) {
                return this.values.get(size / 2);
            }
            return (this.values.get(size / 2 - 1) + this.values.get(size / 2)) / 2.0;
        }
    }
}

