/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import apoc.coll.SetBackedList;
import apoc.result.ListResult;
import com.google.common.util.concurrent.AtomicDouble;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.math3.util.Combinations;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Coll {
    public static final char ASCENDING_ORDER_CHAR = '^';
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @UserFunction
    @Description(value="apoc.coll.runningTotal(list1) - returns an accumulative array. For example apoc.coll.runningTotal([1,2,3.5]) return [1,3,6.5]")
    public List<Number> runningTotal(@Name(value="list") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        AtomicDouble sum = new AtomicDouble();
        return list.stream().map(i -> {
            double value = sum.addAndGet(i.doubleValue());
            if (value == (double)sum.longValue()) {
                return sum.longValue();
            }
            return value;
        }).collect(Collectors.toList());
    }

    @Procedure
    @Description(value="apoc.coll.zipToRows(list1,list2) - creates pairs like zip but emits one row per pair")
    public Stream<ListResult> zipToRows(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        if (list1.isEmpty()) {
            return Stream.empty();
        }
        ListIterator<Object> it = list2.listIterator();
        return list1.stream().map(e -> new ListResult(Arrays.asList(e, it.hasNext() ? it.next() : null)));
    }

    @UserFunction
    @Description(value="apoc.coll.zip([list1],[list2])")
    public List<List<Object>> zip(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        if (list1 == null || list2 == null) {
            return null;
        }
        if (list1.isEmpty() || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(list1.size());
        ListIterator<Object> it = list2.listIterator();
        for (Object o1 : list1) {
            result.add(Arrays.asList(o1, it.hasNext() ? it.next() : null));
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.coll.pairs([1,2,3]) returns [1,2],[2,3],[3,null] ")
    public List<List<Object>> pairs(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return this.zip(list, list.subList(1, list.size()));
    }

    @UserFunction
    @Description(value="apoc.coll.pairsMin([1,2,3]) returns [1,2],[2,3]")
    public List<List<Object>> pairsMin(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return this.zip(list.subList(0, list.size() - 1), list.subList(1, list.size()));
    }

    @UserFunction
    @Description(value="apoc.coll.sum([0.5,1,2.3])")
    public Double sum(@Name(value="numbers") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return sum;
    }

    @UserFunction
    @Description(value="apoc.coll.avg([0.5,1,2.3])")
    public Double avg(@Name(value="numbers") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        double avg = 0.0;
        for (Number number : list) {
            avg += number.doubleValue();
        }
        return avg / (double)list.size();
    }

    @UserFunction
    @Description(value="apoc.coll.min([0.5,1,2.3])")
    public Object min(@Name(value="values") List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        try (Result result = this.tx.execute("cypher runtime=slotted return reduce(res=null, x in $list | CASE WHEN res IS NULL OR x<res THEN x ELSE res END) as value", Collections.singletonMap("list", list));){
            Object v = result.next().get("value");
            return v;
        }
    }

    @UserFunction
    @Description(value="apoc.coll.max([0.5,1,2.3])")
    public Object max(@Name(value="values") List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        try (Result result = this.tx.execute("cypher runtime=slotted return reduce(res=null, x in $list | CASE WHEN res IS NULL OR res<x THEN x ELSE res END) as value", Collections.singletonMap("list", list));){
            Object v = result.next().get("value");
            return v;
        }
    }

    @Procedure
    @Description(value="apoc.coll.elements(list,limit,offset) yield _1,_2,..,_10,_1s,_2i,_3f,_4m,_5l,_6n,_7r,_8p - deconstruct subset of mixed list into identifiers of the correct type")
    public Stream<ElementsResult> elements(@Name(value="values") List<Object> list, @Name(value="limit", defaultValue="-1") long limit, @Name(value="offset", defaultValue="0") long offset) {
        int elements = (limit < 0L ? list.size() : Math.min((int)(offset + limit), list.size())) - (int)offset;
        if (elements > 10) {
            elements = 10;
        }
        ElementsResult result = new ElementsResult();
        for (int i = 0; i < elements; ++i) {
            result.add(list.get((int)offset + i));
        }
        return Stream.of(result);
    }

    @Procedure
    @Description(value="apoc.coll.partition(list,batchSize)")
    public Stream<ListResult> partition(@Name(value="values") List<Object> list, @Name(value="batchSize") long batchSize) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        return this.partitionList(list, (int)batchSize).map(ListResult::new);
    }

    @UserFunction(value="apoc.coll.partition")
    @Description(value="apoc.coll.partition(list,batchSize)")
    public List<Object> partitionFn(@Name(value="values") List<Object> list, @Name(value="batchSize") long batchSize) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<Object>();
        }
        return this.partitionList(list, (int)batchSize).collect(Collectors.toList());
    }

    @Procedure
    @Description(value="apoc.coll.split(list,value) | splits collection on given values rows of lists, value itself will not be part of resulting lists")
    public Stream<ListResult> split(@Name(value="values") List<Object> list, @Name(value="value") Object value) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        List<Object> l = new ArrayList<Object>(list);
        ArrayList result = new ArrayList(10);
        int idx = l.indexOf(value);
        while (idx != -1) {
            List subList = l.subList(0, idx);
            if (!subList.isEmpty()) {
                result.add(subList);
            }
            l = l.subList(idx + 1, l.size());
            idx = l.indexOf(value);
        }
        if (!l.isEmpty()) {
            result.add(l);
        }
        return result.stream().map(ListResult::new);
    }

    private Stream<List<Object>> partitionList(@Name(value="values") List list, @Name(value="batchSize") int batchSize) {
        int total = list.size();
        int pages = total % batchSize == 0 ? total / batchSize : total / batchSize + 1;
        return IntStream.range(0, pages).parallel().boxed().map(page -> {
            int from = page * batchSize;
            return list.subList(from, Math.min(from + batchSize, total));
        });
    }

    @UserFunction
    @Description(value="apoc.coll.contains(coll, value) optimized contains operation (using a HashSet) (returns single row or not)")
    public boolean contains(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        return new HashSet<Object>(coll).contains(value);
    }

    @UserFunction
    @Description(value="apoc.coll.set(coll, index, value) | set index to value")
    public List<Object> set(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="value") Object value) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || value == null || index >= (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.set((int)index, value);
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.insert(coll, index, value) | insert value at index")
    public List<Object> insert(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="value") Object value) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || value == null || index > (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.add((int)index, value);
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.insertAll(coll, index, values) | insert values at index")
    public List<Object> insertAll(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="values") List<Object> values) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || values == null || values.isEmpty() || index > (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.addAll((int)index, values);
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.remove(coll, index, [length=1]) | remove range of values from index to length")
    public List<Object> remove(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="length", defaultValue="1") long length) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || index >= (long)coll.size() || length <= 0L) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        for (long i = index + length - 1L; i >= index; --i) {
            if (i >= (long)list.size()) continue;
            list.remove((int)i);
        }
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.indexOf(coll, value) | position of value in the list")
    public long indexOf(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return -1L;
        }
        return new ArrayList<Object>(coll).indexOf(value);
    }

    @UserFunction
    @Description(value="apoc.coll.containsAll(coll, values) optimized contains-all operation (using a HashSet) (returns single row or not)")
    public boolean containsAll(@Name(value="coll") List<Object> coll, @Name(value="values") List<Object> values) {
        if (coll == null || coll.isEmpty() || values == null) {
            return false;
        }
        return new HashSet<Object>(coll).containsAll(values);
    }

    @UserFunction
    @Description(value="apoc.coll.containsSorted(coll, value) optimized contains on a sorted list operation (Collections.binarySearch) (returns single row or not)")
    public boolean containsSorted(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        return Collections.binarySearch(list, value) >= 0;
    }

    @UserFunction
    @Description(value="apoc.coll.containsAllSorted(coll, value) optimized contains-all on a sorted list operation (Collections.binarySearch) (returns single row or not)")
    public boolean containsAllSorted(@Name(value="coll") List<Object> coll, @Name(value="values") List<Object> values) {
        if (coll == null || values == null) {
            return false;
        }
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        for (Object value : values) {
            boolean result = Collections.binarySearch(list, value) >= 0;
            if (result) continue;
            return false;
        }
        return true;
    }

    @UserFunction
    @Description(value="apoc.coll.isEqualCollection(coll, values) return true if two collections contain the same elements with the same cardinality in any order (using a HashMap)")
    public boolean isEqualCollection(@Name(value="coll") List<Object> first, @Name(value="values") List<Object> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        Map map1 = first.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map map2 = second.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return map1.equals(map2);
    }

    @UserFunction
    @Description(value="apoc.coll.toSet([list]) returns a unique list backed by a set")
    public List<Object> toSet(@Name(value="values") List<Object> list) {
        if (list == null) {
            return null;
        }
        return new SetBackedList<Object>(new LinkedHashSet<Object>(list));
    }

    @UserFunction
    @Description(value="apoc.coll.sumLongs([1,3,3])")
    public Long sumLongs(@Name(value="numbers") List<Number> list) {
        if (list == null) {
            return null;
        }
        long sum = 0L;
        for (Number number : list) {
            sum += number.longValue();
        }
        return sum;
    }

    @UserFunction
    @Description(value="apoc.coll.sort(coll) sort on Collections")
    public List<Object> sort(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> sorted = new ArrayList<Object>(coll);
        Collections.sort(sorted);
        return sorted;
    }

    @UserFunction
    @Description(value="apoc.coll.sortNodes([nodes], 'name') sort nodes by property")
    public List<Node> sortNodes(@Name(value="coll") List<Node> coll, @Name(value="prop") String prop) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Node> sorted = new ArrayList<Node>(coll);
        int reverseOrder = this.reverseOrder(prop);
        String cleanedProp = this.cleanProperty(prop);
        Collections.sort(sorted, (x, y) -> reverseOrder * Coll.compare(x.getProperty(cleanedProp, null), y.getProperty(cleanedProp, null)));
        return sorted;
    }

    @UserFunction
    @Description(value="apoc.coll.sortMaps([maps], 'name') - sort maps by property")
    public List<Map<String, Object>> sortMaps(@Name(value="coll") List<Map<String, Object>> coll, @Name(value="prop") String prop) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> sorted = new ArrayList<Map<String, Object>>(coll);
        int reverseOrder = this.reverseOrder(prop);
        String cleanedProp = this.cleanProperty(prop);
        Collections.sort(sorted, (x, y) -> reverseOrder * Coll.compare(x.get(cleanedProp), y.get(cleanedProp)));
        return sorted;
    }

    public int reverseOrder(String prop) {
        return prop.charAt(0) == '^' ? 1 : -1;
    }

    public String cleanProperty(String prop) {
        return prop.charAt(0) == '^' ? prop.substring(1) : prop;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1 instanceof Double || o2 instanceof Double || o1 instanceof Float || o2 instanceof Float) {
                return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
            }
            return Long.compare(((Number)o1).longValue(), ((Number)o2).longValue());
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return (Boolean)o1 != false ? 1 : -1;
        }
        if (o1 instanceof Node && o2 instanceof Node) {
            return Long.compare(((Node)o1).getId(), ((Node)o2).getId());
        }
        if (o1 instanceof Relationship && o2 instanceof Relationship) {
            return Long.compare(((Relationship)o1).getId(), ((Relationship)o2).getId());
        }
        return o1.toString().compareTo(o2.toString());
    }

    @UserFunction
    @Description(value="apoc.coll.union(first, second) - creates the distinct union of the 2 lists")
    public List<Object> union(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        HashSet<Object> set = new HashSet<Object>(first);
        set.addAll(second);
        return new SetBackedList<Object>(set);
    }

    @UserFunction
    @Description(value="apoc.coll.subtract(first, second) - returns unique set of first list with all elements of second list removed")
    public List<Object> subtract(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>(first);
        if (second != null) {
            set.removeAll(second);
        }
        return new SetBackedList<Object>(set);
    }

    @UserFunction
    @Description(value="apoc.coll.removeAll(first, second) - returns first list with all elements of second list removed")
    public List<Object> removeAll(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(first);
        if (second != null) {
            list.removeAll(second);
        }
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.intersection(first, second) - returns the unique intersection of the two lists")
    public List<Object> intersection(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null || second == null) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(first);
        set.retainAll(second);
        return new SetBackedList<Object>(set);
    }

    @UserFunction
    @Description(value="apoc.coll.disjunction(first, second) - returns the disjunct set of the two lists")
    public List<Object> disjunction(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        HashSet<Object> intersection = new HashSet<Object>(first);
        intersection.retainAll(second);
        HashSet<Object> set = new HashSet<Object>(first);
        set.addAll(second);
        set.removeAll(intersection);
        return new SetBackedList<Object>(set);
    }

    @UserFunction
    @Description(value="apoc.coll.unionAll(first, second) - creates the full union with duplicates of the two lists")
    public List<Object> unionAll(@Name(value="first") List<Object> first, @Name(value="second") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        ArrayList<Object> list = new ArrayList<Object>(first);
        list.addAll(second);
        return list;
    }

    @UserFunction
    @Description(value="apoc.coll.shuffle(coll) - returns the shuffled list")
    public List<Object> shuffle(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (coll.size() == 1) {
            return coll;
        }
        ArrayList<Object> shuffledList = new ArrayList<Object>(coll);
        Collections.shuffle(shuffledList);
        return shuffledList;
    }

    @UserFunction
    @Description(value="apoc.coll.randomItem(coll)- returns a random item from the list, or null on an empty or null list")
    public Object randomItem(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.get(0);
        }
        return coll.get(ThreadLocalRandom.current().nextInt(coll.size()));
    }

    @UserFunction
    @Description(value="apoc.coll.randomItems(coll, itemCount, allowRepick: false) - returns a list of itemCount random items from the original list, optionally allowing picked elements to be picked again")
    public List<Object> randomItems(@Name(value="coll") List<Object> coll, @Name(value="itemCount") long itemCount, @Name(value="allowRepick", defaultValue="false") boolean allowRepick) {
        if (coll == null || coll.isEmpty() || itemCount <= 0L) {
            return Collections.emptyList();
        }
        ArrayList<Object> pickList = new ArrayList<Object>(coll);
        ArrayList<Object> randomItems = new ArrayList<Object>((int)itemCount);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!allowRepick && itemCount >= (long)coll.size()) {
            Collections.shuffle(pickList);
            return pickList;
        }
        while ((long)randomItems.size() < itemCount) {
            Object item = allowRepick ? pickList.get(((Random)random).nextInt(pickList.size())) : pickList.remove(((Random)random).nextInt(pickList.size()));
            randomItems.add(item);
        }
        return randomItems;
    }

    @UserFunction
    @Description(value="apoc.coll.containsDuplicates(coll) - returns true if a collection contains duplicate elements")
    public boolean containsDuplicates(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(coll);
        return set.size() < coll.size();
    }

    @UserFunction
    @Description(value="apoc.coll.duplicates(coll) - returns a list of duplicate items in the collection")
    public List<Object> duplicates(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(coll.size());
        LinkedHashSet<Object> duplicates = new LinkedHashSet<Object>();
        for (Object obj : coll) {
            if (set.add(obj)) continue;
            duplicates.add(obj);
        }
        return new ArrayList<Object>(duplicates);
    }

    @UserFunction
    @Description(value="apoc.coll.duplicatesWithCount(coll) - returns a list of duplicate items in the collection and their count, keyed by `item` and `count` (e.g., `[{item: xyz, count:2}, {item:zyx, count:5}]`)")
    public List<Map<String, Object>> duplicatesWithCount(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, MutableInt> duplicates = new LinkedHashMap<Object, MutableInt>(coll.size());
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Object obj : coll) {
            MutableInt counter = (MutableInt)duplicates.get(obj);
            if (counter == null) {
                counter = new MutableInt();
                duplicates.put(obj, counter);
            }
            counter.increment();
        }
        duplicates.forEach((o, intCounter) -> {
            int count = intCounter.intValue();
            if (count > 1) {
                LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(2);
                entry.put("item", o);
                entry.put("count", Long.valueOf(count));
                resultList.add(entry);
            }
        });
        return resultList;
    }

    @UserFunction
    @Description(value="apoc.coll.frequencies(coll) - returns a list of frequencies of the items in the collection, keyed by `item` and `count` (e.g., `[{item: xyz, count:2}, {item:zyx, count:5}, {item:abc, count:1}]`)")
    public List<Map<String, Object>> frequencies(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, MutableInt> counts = new LinkedHashMap<Object, MutableInt>(coll.size());
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Object obj : coll) {
            MutableInt counter = (MutableInt)counts.get(obj);
            if (counter == null) {
                counter = new MutableInt();
                counts.put(obj, counter);
            }
            counter.increment();
        }
        counts.forEach((o, intCounter) -> {
            int count = intCounter.intValue();
            LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(2);
            entry.put("item", o);
            entry.put("count", Long.valueOf(count));
            resultList.add(entry);
        });
        return resultList;
    }

    @UserFunction
    @Description(value="apoc.coll.frequenciesAsMap(coll) - return a map of frequencies of the items in the collection, key `item`, value `count` (e.g., `{1:2, 2:1}`)")
    public Map<String, Object> frequenciesAsMap(@Name(value="coll") List<Object> coll) {
        if (coll == null) {
            return Collections.emptyMap();
        }
        return this.frequencies(coll).stream().collect(Collectors.toMap(t -> t.get("item").toString(), v -> v.get("count")));
    }

    @UserFunction
    @Description(value="apoc.coll.occurrences(coll, item) - returns the count of the given item in the collection")
    public long occurrences(@Name(value="coll") List<Object> coll, @Name(value="item") Object item) {
        if (coll == null || coll.isEmpty()) {
            return 0L;
        }
        long occurrences = 0L;
        for (Object obj : coll) {
            if (!item.equals(obj)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    @UserFunction
    @Description(value="apoc.coll.flatten(coll, [recursive]) - flattens list (nested if recursive is true)")
    public List<Object> flatten(@Name(value="coll") List<Object> coll, @Name(value="recursive", defaultValue="false") boolean recursive) {
        if (coll == null) {
            return Collections.emptyList();
        }
        if (recursive) {
            return Coll.flattenRecursive(coll, 0);
        }
        return Coll.flattenRecursive(coll, 0, 2);
    }

    private static List<Object> flattenRecursive(Object aObject, int aDepth, int aStopDepth) {
        ArrayList<Object> vResult = new ArrayList<Object>();
        if (aDepth == aStopDepth) {
            vResult.add(aObject);
        } else if (aObject.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(aObject); ++i) {
                vResult.addAll(Coll.flattenRecursive(Array.get(aObject, i), aDepth + 1, aStopDepth));
            }
        } else if (aObject instanceof List) {
            for (Object vElement : (List)aObject) {
                vResult.addAll(Coll.flattenRecursive(vElement, aDepth + 1, aStopDepth));
            }
        } else {
            vResult.add(aObject);
        }
        return vResult;
    }

    private static List<Object> flattenRecursive(Object aObject, int aDepth) {
        return Coll.flattenRecursive(aObject, aDepth, -1);
    }

    @Deprecated
    @UserFunction
    @Description(value="apoc.coll.reverse(coll) - returns reversed list")
    public List<Object> reverse(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (coll.size() == 1) {
            return coll;
        }
        ArrayList<Object> reversed = new ArrayList<Object>(coll);
        Collections.reverse(reversed);
        return reversed;
    }

    @UserFunction(value="apoc.coll.sortMulti")
    @Description(value="apoc.coll.sortMulti(coll, ['^name','age'],[limit],[skip]) - sort list of maps by several sort fields (ascending with ^ prefix) and optionally applies limit and skip")
    public List<Map<String, Object>> sortMulti(@Name(value="coll") List<Map<String, Object>> coll, @Name(value="orderFields", defaultValue="[]") List<String> orderFields, @Name(value="limit", defaultValue="-1") long limit, @Name(value="skip", defaultValue="0") long skip) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(coll);
        if (orderFields != null && !orderFields.isEmpty()) {
            List fields = orderFields.stream().map(v -> {
                boolean asc = v.charAt(0) == '^';
                return Pair.of((Object)(asc ? v.substring(1) : v), (Object)asc);
            }).collect(Collectors.toList());
            Comparator compare = (o1, o2) -> {
                int a = 0;
                for (Pair s : fields) {
                    Comparable v2;
                    if (a != 0) break;
                    String name = (String)s.first();
                    Comparable v1 = (Comparable)o1.get(name);
                    if (v1 == (v2 = (Comparable)o2.get(name))) continue;
                    int cmp = v1 == null ? -1 : (v2 == null ? 1 : v1.compareTo(v2));
                    a = (Boolean)s.other() != false ? cmp : -cmp;
                }
                return a;
            };
            Collections.sort(result, compare);
        }
        if (skip > 0L && limit != -1L) {
            return result.subList((int)skip, (int)(skip + limit));
        }
        if (skip > 0L) {
            return result.subList((int)skip, result.size());
        }
        if (limit != -1L) {
            return result.subList(0, (int)limit);
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.coll.combinations(coll, minSelect, maxSelect:minSelect) - Returns collection of all combinations of list elements of selection size between minSelect and maxSelect (default:minSelect), inclusive")
    public List<List<Object>> combinations(@Name(value="coll") List<Object> coll, @Name(value="minSelect") long minSelectIn, @Name(value="maxSelect", defaultValue="-1") long maxSelectIn) {
        int minSelect = (int)minSelectIn;
        int maxSelect = (int)maxSelectIn;
        int n = maxSelect = maxSelect == -1 ? minSelect : maxSelect;
        if (coll == null || coll.isEmpty() || minSelect < 1 || minSelect > coll.size() || minSelect > maxSelect || maxSelect > coll.size()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> combinations = new ArrayList<List<Object>>();
        for (int i = minSelect; i <= maxSelect; ++i) {
            Iterator<int[]> itr = new Combinations(coll.size(), i).iterator();
            while (itr.hasNext()) {
                ArrayList<Object> entry = new ArrayList<Object>(i);
                int[] indexes = itr.next();
                if (indexes.length <= 0) continue;
                for (int index : indexes) {
                    entry.add(coll.get(index));
                }
                combinations.add(entry);
            }
        }
        return combinations;
    }

    @UserFunction
    @Description(value="apoc.coll.different(values) - returns true if values are different")
    public boolean different(@Name(value="values") List<Object> values) {
        if (values == null) {
            return false;
        }
        return new HashSet<Object>(values).size() == values.size();
    }

    @UserFunction
    @Description(value="apoc.coll.dropDuplicateNeighbors(list) - remove duplicate consecutive objects in a list")
    public List<Object> dropDuplicateNeighbors(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        Object last = null;
        for (Object element : list) {
            if ((element != null || last == null) && (element == null || element.equals(last))) continue;
            newList.add(element);
            last = element;
        }
        return newList;
    }

    @UserFunction
    @Description(value="apoc.coll.fill(item, count) - returns a list with the given count of items")
    public List<Object> fill(@Name(value="item") String item, @Name(value="count") long count) {
        return Collections.nCopies((int)count, item);
    }

    @UserFunction
    @Description(value="apoc.coll.sortText(coll) sort on string based collections")
    public List<String> sortText(@Name(value="coll") List<String> coll, @Name(value="conf", defaultValue="{}") Map<String, Object> conf) {
        if (conf == null) {
            conf = Collections.emptyMap();
        }
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> sorted = new ArrayList<String>(coll);
        String localeAsStr = conf.getOrDefault("locale", "").toString();
        Locale locale = !localeAsStr.isBlank() ? Locale.forLanguageTag(localeAsStr) : null;
        Collator collator = locale != null ? Collator.getInstance(locale) : Collator.getInstance();
        Collections.sort(sorted, collator);
        return sorted;
    }

    @UserFunction(value="apoc.coll.pairWithOffset")
    @Description(value="apoc.coll.pairWithOffset(values, offset) - returns a list of pairs defined by the offset")
    public List<List<Object>> pairWithOffsetFn(@Name(value="values") List<Object> values, @Name(value="offset") long offset) {
        if (values == null) {
            return null;
        }
        BiFunction<List, Long, Object> extract = (list, index) -> index < (long)list.size() && index >= 0L ? list.get(index.intValue()) : null;
        int length = Double.valueOf(Math.ceil((double)values.size() / (double)Math.abs(offset))).intValue();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(length);
        for (long i = 0L; i < (long)values.size(); ++i) {
            List<Object> objects = Arrays.asList(extract.apply(values, i), extract.apply(values, i + offset));
            result.add(objects);
        }
        return result;
    }

    @Procedure
    @Description(value="apoc.coll.pairWithOffset(values, offset) - returns a list of pairs defined by the offset")
    public Stream<ListResult> pairWithOffset(@Name(value="values") List<Object> values, @Name(value="offset") long offset) {
        return this.pairWithOffsetFn(values, offset).stream().map(ListResult::new);
    }

    public static class ElementsResult {
        public Object _1;
        public Object _2;
        public Object _3;
        public Object _4;
        public Object _5;
        public Object _6;
        public Object _7;
        public Object _8;
        public Object _9;
        public Object _10;
        public String _1s;
        public String _2s;
        public String _3s;
        public String _4s;
        public String _5s;
        public String _6s;
        public String _7s;
        public String _8s;
        public String _9s;
        public String _10s;
        public Long _1i;
        public Long _2i;
        public Long _3i;
        public Long _4i;
        public Long _5i;
        public Long _6i;
        public Long _7i;
        public Long _8i;
        public Long _9i;
        public Long _10i;
        public Double _1f;
        public Double _2f;
        public Double _3f;
        public Double _4f;
        public Double _5f;
        public Double _6f;
        public Double _7f;
        public Double _8f;
        public Double _9f;
        public Double _10f;
        public Boolean _1b;
        public Boolean _2b;
        public Boolean _3b;
        public Boolean _4b;
        public Boolean _5b;
        public Boolean _6b;
        public Boolean _7b;
        public Boolean _8b;
        public Boolean _9b;
        public Boolean _10b;
        public List<Object> _1l;
        public List<Object> _2l;
        public List<Object> _3l;
        public List<Object> _4l;
        public List<Object> _5l;
        public List<Object> _6l;
        public List<Object> _7l;
        public List<Object> _8l;
        public List<Object> _9l;
        public List<Object> _10l;
        public Map<String, Object> _1m;
        public Map<String, Object> _2m;
        public Map<String, Object> _3m;
        public Map<String, Object> _4m;
        public Map<String, Object> _5m;
        public Map<String, Object> _6m;
        public Map<String, Object> _7m;
        public Map<String, Object> _8m;
        public Map<String, Object> _9m;
        public Map<String, Object> _10m;
        public Node _1n;
        public Node _2n;
        public Node _3n;
        public Node _4n;
        public Node _5n;
        public Node _6n;
        public Node _7n;
        public Node _8n;
        public Node _9n;
        public Node _10n;
        public Relationship _1r;
        public Relationship _2r;
        public Relationship _3r;
        public Relationship _4r;
        public Relationship _5r;
        public Relationship _6r;
        public Relationship _7r;
        public Relationship _8r;
        public Relationship _9r;
        public Relationship _10r;
        public Path _1p;
        public Path _2p;
        public Path _3p;
        public Path _4p;
        public Path _5p;
        public Path _6p;
        public Path _7p;
        public Path _8p;
        public Path _9p;
        public Path _10p;
        public long elements;
        static final int MAX_ELEMENTS = 10;

        void add(Object o) {
            if (this.elements == 10L) {
                return;
            }
            this.setObject(o, (int)this.elements);
            if (o instanceof String) {
                this.setString((String)o, (int)this.elements);
            }
            if (o instanceof Number) {
                this.setLong(((Number)o).longValue(), (int)this.elements);
                this.setDouble(((Number)o).doubleValue(), (int)this.elements);
            }
            if (o instanceof Boolean) {
                this.setBoolean((Boolean)o, (int)this.elements);
            }
            if (o instanceof Map) {
                this.setMap((Map)o, (int)this.elements);
            }
            if (o instanceof Map) {
                this.setMap((Map)o, (int)this.elements);
            }
            if (o instanceof List) {
                this.setList((List)o, (int)this.elements);
            }
            if (o instanceof Node) {
                this.setNode((Node)o, (int)this.elements);
            }
            if (o instanceof Relationship) {
                this.setRelationship((Relationship)o, (int)this.elements);
            }
            if (o instanceof Path) {
                this.setPath((Path)o, (int)this.elements);
            }
            ++this.elements;
        }

        public void setObject(Object o, int idx) {
            switch (idx) {
                case 0: {
                    this._1 = o;
                    break;
                }
                case 1: {
                    this._2 = o;
                    break;
                }
                case 2: {
                    this._3 = o;
                    break;
                }
                case 3: {
                    this._4 = o;
                    break;
                }
                case 4: {
                    this._5 = o;
                    break;
                }
                case 5: {
                    this._6 = o;
                    break;
                }
                case 6: {
                    this._7 = o;
                    break;
                }
                case 7: {
                    this._8 = o;
                    break;
                }
                case 8: {
                    this._9 = o;
                    break;
                }
                case 9: {
                    this._10 = o;
                }
            }
        }

        public void setString(String o, int idx) {
            switch (idx) {
                case 0: {
                    this._1s = o;
                    break;
                }
                case 1: {
                    this._2s = o;
                    break;
                }
                case 2: {
                    this._3s = o;
                    break;
                }
                case 3: {
                    this._4s = o;
                    break;
                }
                case 4: {
                    this._5s = o;
                    break;
                }
                case 5: {
                    this._6s = o;
                    break;
                }
                case 6: {
                    this._7s = o;
                    break;
                }
                case 7: {
                    this._8s = o;
                    break;
                }
                case 8: {
                    this._9s = o;
                    break;
                }
                case 9: {
                    this._10s = o;
                }
            }
        }

        public void setLong(Long o, int idx) {
            switch (idx) {
                case 0: {
                    this._1i = o;
                    break;
                }
                case 1: {
                    this._2i = o;
                    break;
                }
                case 2: {
                    this._3i = o;
                    break;
                }
                case 3: {
                    this._4i = o;
                    break;
                }
                case 4: {
                    this._5i = o;
                    break;
                }
                case 5: {
                    this._6i = o;
                    break;
                }
                case 6: {
                    this._7i = o;
                    break;
                }
                case 7: {
                    this._8i = o;
                    break;
                }
                case 8: {
                    this._9i = o;
                    break;
                }
                case 9: {
                    this._10i = o;
                }
            }
        }

        public void setBoolean(Boolean o, int idx) {
            switch (idx) {
                case 0: {
                    this._1b = o;
                    break;
                }
                case 1: {
                    this._2b = o;
                    break;
                }
                case 2: {
                    this._3b = o;
                    break;
                }
                case 3: {
                    this._4b = o;
                    break;
                }
                case 4: {
                    this._5b = o;
                    break;
                }
                case 5: {
                    this._6b = o;
                    break;
                }
                case 6: {
                    this._7b = o;
                    break;
                }
                case 7: {
                    this._8b = o;
                    break;
                }
                case 8: {
                    this._9b = o;
                    break;
                }
                case 9: {
                    this._10b = o;
                }
            }
        }

        public void setDouble(Double o, int idx) {
            switch (idx) {
                case 0: {
                    this._1f = o;
                    break;
                }
                case 1: {
                    this._2f = o;
                    break;
                }
                case 2: {
                    this._3f = o;
                    break;
                }
                case 3: {
                    this._4f = o;
                    break;
                }
                case 4: {
                    this._5f = o;
                    break;
                }
                case 5: {
                    this._6f = o;
                    break;
                }
                case 6: {
                    this._7f = o;
                    break;
                }
                case 7: {
                    this._8f = o;
                    break;
                }
                case 8: {
                    this._9f = o;
                    break;
                }
                case 9: {
                    this._10f = o;
                }
            }
        }

        public void setNode(Node o, int idx) {
            switch (idx) {
                case 0: {
                    this._1n = o;
                    break;
                }
                case 1: {
                    this._2n = o;
                    break;
                }
                case 2: {
                    this._3n = o;
                    break;
                }
                case 3: {
                    this._4n = o;
                    break;
                }
                case 4: {
                    this._5n = o;
                    break;
                }
                case 5: {
                    this._6n = o;
                    break;
                }
                case 6: {
                    this._7n = o;
                    break;
                }
                case 7: {
                    this._8n = o;
                    break;
                }
                case 8: {
                    this._9n = o;
                    break;
                }
                case 9: {
                    this._10n = o;
                }
            }
        }

        public void setRelationship(Relationship o, int idx) {
            switch (idx) {
                case 0: {
                    this._1r = o;
                    break;
                }
                case 1: {
                    this._2r = o;
                    break;
                }
                case 2: {
                    this._3r = o;
                    break;
                }
                case 3: {
                    this._4r = o;
                    break;
                }
                case 4: {
                    this._5r = o;
                    break;
                }
                case 5: {
                    this._6r = o;
                    break;
                }
                case 6: {
                    this._7r = o;
                    break;
                }
                case 7: {
                    this._8r = o;
                    break;
                }
                case 8: {
                    this._9r = o;
                    break;
                }
                case 9: {
                    this._10r = o;
                }
            }
        }

        public void setPath(Path o, int idx) {
            switch (idx) {
                case 0: {
                    this._1p = o;
                    break;
                }
                case 1: {
                    this._2p = o;
                    break;
                }
                case 2: {
                    this._3p = o;
                    break;
                }
                case 3: {
                    this._4p = o;
                    break;
                }
                case 4: {
                    this._5p = o;
                    break;
                }
                case 5: {
                    this._6p = o;
                    break;
                }
                case 6: {
                    this._7p = o;
                    break;
                }
                case 7: {
                    this._8p = o;
                    break;
                }
                case 8: {
                    this._9p = o;
                    break;
                }
                case 9: {
                    this._10p = o;
                }
            }
        }

        public void setMap(Map o, int idx) {
            switch (idx) {
                case 0: {
                    this._1m = o;
                    break;
                }
                case 1: {
                    this._2m = o;
                    break;
                }
                case 2: {
                    this._3m = o;
                    break;
                }
                case 3: {
                    this._4m = o;
                    break;
                }
                case 4: {
                    this._5m = o;
                    break;
                }
                case 5: {
                    this._6m = o;
                    break;
                }
                case 6: {
                    this._7m = o;
                    break;
                }
                case 7: {
                    this._8m = o;
                    break;
                }
                case 8: {
                    this._9m = o;
                    break;
                }
                case 9: {
                    this._10m = o;
                }
            }
        }

        public void setList(List o, int idx) {
            switch (idx) {
                case 0: {
                    this._1l = o;
                    break;
                }
                case 1: {
                    this._2l = o;
                    break;
                }
                case 2: {
                    this._3l = o;
                    break;
                }
                case 3: {
                    this._4l = o;
                    break;
                }
                case 4: {
                    this._5l = o;
                    break;
                }
                case 5: {
                    this._6l = o;
                    break;
                }
                case 6: {
                    this._7l = o;
                    break;
                }
                case 7: {
                    this._8l = o;
                    break;
                }
                case 8: {
                    this._9l = o;
                    break;
                }
                case 9: {
                    this._10l = o;
                }
            }
        }
    }
}

