/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;

public class SetBackedList<T>
extends AbstractSequentialList<T>
implements Set<T> {
    private final Set<T> set;

    public SetBackedList(Set<T> set) {
        this.set = set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            Iterator<T> it;
            T current;
            int idx;
            {
                this.it = SetBackedList.this.set.iterator();
                this.current = null;
                this.idx = 0;
                this.moveTo(index);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                ++this.idx;
                this.current = this.it.next();
                return this.current;
            }

            @Override
            public boolean hasPrevious() {
                return this.idx > 0;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                Object tmp = this.current;
                this.moveTo(this.idx - 1);
                return tmp;
            }

            private void moveTo(int pos) {
                Iterator it2 = SetBackedList.this.set.iterator();
                Object value = null;
                int i = 0;
                while (i++ < pos) {
                    value = it2.next();
                }
                this.it = it2;
                this.idx = pos;
                this.current = value;
            }

            @Override
            public int nextIndex() {
                return this.idx;
            }

            @Override
            public int previousIndex() {
                return this.idx - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public void set(Object o) {
                throw new UnsupportedOperationException("set");
            }

            @Override
            public void add(Object o) {
                throw new UnsupportedOperationException("add");
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Set) {
            return this.set.equals(o);
        }
        return o instanceof Iterable && super.equals(o);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.set.spliterator();
    }
}

