/*
 * Decompiled with CFR 0.152.
 */
package apoc.config;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.result.MapResult;
import apoc.util.Util;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

@Extended
public class Config {
    @Context
    public SecurityContext securityContext;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public DependencyResolver dependencyResolver;

    @Description(value="apoc.config.list | Lists the Neo4j configuration as key,value table")
    @Procedure
    public Stream<ConfigResult> list() {
        Util.checkAdmin(this.securityContext, this.callContext, "apoc.config.list");
        Configuration config = ((ApocConfig)((Object)this.dependencyResolver.resolveDependency(ApocConfig.class))).getConfig();
        return Iterators.stream(config.getKeys()).map(s -> new ConfigResult((String)s, config.getString((String)s)));
    }

    @Description(value="apoc.config.map | Lists the Neo4j configuration as map")
    @Procedure
    public Stream<MapResult> map() {
        Util.checkAdmin(this.securityContext, this.callContext, "apoc.config.map");
        Configuration config = ((ApocConfig)((Object)this.dependencyResolver.resolveDependency(ApocConfig.class))).getConfig();
        Map<String, Object> configMap = Iterators.stream(config.getKeys()).collect(Collectors.toMap(s -> s, s -> config.getString((String)s)));
        return Stream.of(new MapResult(configMap));
    }

    public static class ConfigResult {
        public final String key;
        public final Object value;

        public ConfigResult(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

