/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.couchbase.CouchbaseManager;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.codec.RawBinaryTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;

public class CouchbaseConnection
implements AutoCloseable {
    private static final String SPLIT_URI_KEY = ",";
    private Cluster cluster;
    private Bucket bucket;
    private Collection collection;
    private BinaryCollection binaryCollection;
    private ClusterEnvironment env;

    protected CouchbaseConnection(String hostOrKey, PasswordAuthenticator authenticator, String bucketName, ClusterEnvironment env) {
        Set<Object> seedNodes;
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            Configuration couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            int port = couchbaseConfig.getInt("port", -1);
            String url = couchbaseConfig.getString("uri", null);
            if (url == null) {
                throw new RuntimeException("Please check you 'apoc.couchbase." + hostOrKey + "' configuration, url is missing");
            }
            List<String> splitUrl = Arrays.asList(url.split(SPLIT_URI_KEY));
            seedNodes = splitUrl.stream().map(singleUri -> SeedNode.create((String)singleUri, Optional.empty(), port != -1 ? Optional.of(port) : Optional.empty())).collect(Collectors.toSet());
        } else {
            String url = singleHostURI.getHost();
            int port = singleHostURI.getPort();
            seedNodes = Set.of(SeedNode.create((String)url, Optional.empty(), port != -1 ? Optional.of(port) : Optional.empty()));
        }
        this.env = env;
        this.cluster = Cluster.connect(seedNodes, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(env));
        this.bucket = this.cluster.bucket(bucketName);
        this.collection = this.bucket.defaultCollection();
        this.binaryCollection = this.collection.binary();
    }

    @Override
    public void close() {
        this.cluster.disconnect();
        this.env.shutdown();
    }

    public Collection getCollection() {
        return this.collection;
    }

    public GetResult get(String documentId) {
        try {
            return this.collection.get(documentId, GetOptions.getOptions().withExpiry(true));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public GetResult getBinary(String documentId) {
        try {
            return this.collection.get(documentId, GetOptions.getOptions().transcoder((Transcoder)RawBinaryTranscoder.INSTANCE).withExpiry(true));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public boolean exists(String documentId) {
        return this.collection.exists(documentId).exists();
    }

    public MutationResult insert(String documentId, String json) {
        return this.collection.insert(documentId, (Object)JsonObject.fromJson((String)json));
    }

    public MutationResult upsert(String documentId, String json) {
        return this.collection.upsert(documentId, (Object)JsonObject.fromJson((String)json));
    }

    public MutationResult append(String documentId, byte[] content) {
        return this.binaryCollection.append(documentId, content);
    }

    public MutationResult prepend(String documentId, byte[] content) {
        return this.binaryCollection.prepend(documentId, content);
    }

    public MutationResult remove(String documentId) {
        return this.collection.remove(documentId);
    }

    public MutationResult replace(String documentId, String json) {
        return this.collection.replace(documentId, (Object)JsonObject.fromJson((String)json));
    }

    public List<JsonObject> executeStatement(String statement) {
        return this.cluster.query(statement).rowsAsObject();
    }

    public List<JsonObject> executeParameterizedStatement(String statement, List<Object> parameters) {
        JsonArray positionalParams = JsonArray.from(parameters);
        QueryResult queryResult = this.cluster.query(statement, QueryOptions.queryOptions().parameters(positionalParams));
        return queryResult.rowsAsObject();
    }

    public List<JsonObject> executeParameterizedStatement(String statement, List<String> parameterNames, List<Object> parameterValues) {
        JsonObject namedParams = JsonObject.create();
        for (int param = 0; param < parameterNames.size(); ++param) {
            namedParams.put(parameterNames.get(param), parameterValues.get(param));
        }
        QueryResult queryResult = this.cluster.query(statement, QueryOptions.queryOptions().parameters(namedParams));
        return queryResult.rowsAsObject();
    }
}

