/*
 * Decompiled with CFR 0.152.
 */
package apoc.create;

import apoc.get.Get;
import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualPathResult;
import apoc.result.VirtualRelationship;
import apoc.util.Util;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Create {
    public static final String[] EMPTY_ARRAY = new String[0];
    @Context
    public Transaction tx;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.node(['Label'], {key:value,...}) - create node with dynamic labels")
    public Stream<NodeResult> node(@Name(value="label") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        return Stream.of(new NodeResult(this.setProperties(this.tx.createNode(Util.labels(labelNames)), props)));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.addLabels( [node,id,ids,nodes], ['Label',...]) - adds the given labels to the node or nodes")
    public Stream<NodeResult> addLabels(@Name(value="nodes") Object nodes, @Name(value="label") List<String> labelNames) {
        Label[] labels2 = Util.labels(labelNames);
        return new Get(this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : labels2) {
                node.addLabel(label);
            }
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.setProperty( [node,id,ids,nodes], key, value) - sets the given property on the node(s)")
    public Stream<NodeResult> setProperty(@Name(value="nodes") Object nodes, @Name(value="key") String key, @Name(value="value") Object value) {
        return new Get(this.tx).nodes(nodes).map(r -> {
            this.setProperty((Entity)r.node, key, this.toPropertyValue(value));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.setRelProperty( [rel,id,ids,rels], key, value) - sets the given property on the relationship(s)")
    public Stream<RelationshipResult> setRelProperty(@Name(value="relationships") Object rels, @Name(value="key") String key, @Name(value="value") Object value) {
        return new Get(this.tx).rels(rels).map(r -> {
            this.setProperty((Entity)r.rel, key, this.toPropertyValue(value));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.setProperties( [node,id,ids,nodes], [keys], [values]) - sets the given properties on the nodes(s)")
    public Stream<NodeResult> setProperties(@Name(value="nodes") Object nodes, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return new Get(this.tx).nodes(nodes).map(r -> {
            this.setProperties(r.node, Util.mapFromLists(keys, values));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.removeProperties( [node,id,ids,nodes], [keys]) - removes the given properties from the nodes(s)")
    public Stream<NodeResult> removeProperties(@Name(value="nodes") Object nodes, @Name(value="keys") List<String> keys) {
        return new Get(this.tx).nodes(nodes).map(r -> {
            keys.forEach(arg_0 -> ((Node)r.node).removeProperty(arg_0));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.setRelProperties( [rel,id,ids,rels], [keys], [values]) - sets the given properties on the relationship(s)")
    public Stream<RelationshipResult> setRelProperties(@Name(value="rels") Object rels, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return new Get(this.tx).rels(rels).map(r -> {
            this.setProperties(r.rel, Util.mapFromLists(keys, values));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.removeRelProperties( [rel,id,ids,rels], [keys]) - removes the given properties from the relationship(s)")
    public Stream<RelationshipResult> removeRelProperties(@Name(value="rels") Object rels, @Name(value="keys") List<String> keys) {
        return new Get(this.tx).rels(rels).map(r -> {
            keys.forEach(arg_0 -> ((Relationship)r.rel).removeProperty(arg_0));
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.setLabels( [node,id,ids,nodes], ['Label',...]) - sets the given labels, non matching labels are removed on the node or nodes")
    public Stream<NodeResult> setLabels(@Name(value="nodes") Object nodes, @Name(value="label") List<String> labelNames) {
        Label[] labels2 = Util.labels(labelNames);
        return new Get(this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : node.getLabels()) {
                if (labelNames.contains(label.name())) continue;
                node.removeLabel(label);
            }
            for (Label label : labels2) {
                if (node.hasLabel(label)) continue;
                node.addLabel(label);
            }
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.removeLabels( [node,id,ids,nodes], ['Label',...]) - removes the given labels from the node or nodes")
    public Stream<NodeResult> removeLabels(@Name(value="nodes") Object nodes, @Name(value="label") List<String> labelNames) {
        Label[] labels2 = Util.labels(labelNames);
        return new Get(this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : labels2) {
                node.removeLabel(label);
            }
            return r;
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.nodes(['Label'], [{key:value,...}]) create multiple nodes with dynamic labels")
    public Stream<NodeResult> nodes(@Name(value="label") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels2 = Util.labels(labelNames);
        return props.stream().map(p -> new NodeResult(this.setProperties((Entity)this.tx.createNode(labels2), (Map<String, Object>)p)));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.create.relationship(person1,'KNOWS',{key:value,...}, person2) create relationship with dynamic rel-type")
    public Stream<RelationshipResult> relationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return Stream.of(new RelationshipResult(this.setProperties(from.createRelationshipTo(to, RelationshipType.withName((String)relType)), props)));
    }

    @Procedure
    @Description(value="apoc.create.vNode(['Label'], {key:value,...}) returns a virtual node")
    public Stream<NodeResult> vNode(@Name(value="label") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        return Stream.of(new NodeResult(this.vNodeFunction(labelNames, props)));
    }

    @UserFunction(value="apoc.create.vNode")
    @Description(value="apoc.create.vNode(['Label'], {key:value,...}) returns a virtual node")
    public Node vNodeFunction(@Name(value="label") List<String> labelNames, @Name(value="props", defaultValue="{}") Map<String, Object> props) {
        return new VirtualNode(Util.labels(labelNames), props);
    }

    @UserFunction(value="apoc.create.virtual.fromNode")
    @Description(value="apoc.create.virtual.fromNode(node, [propertyNames]) returns a virtual node built from an existing node with only the requested properties")
    public Node virtualFromNodeFunction(@Name(value="node") Node node, @Name(value="propertyNames") List<String> propertyNames) {
        return new VirtualNode(node, propertyNames);
    }

    @Procedure
    @Description(value="apoc.create.vNodes(['Label'], [{key:value,...}]) returns virtual nodes")
    public Stream<NodeResult> vNodes(@Name(value="label") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels2 = Util.labels(labelNames);
        return props.stream().map(p -> new NodeResult(new VirtualNode(labels2, (Map<String, Object>)p)));
    }

    @Procedure
    @Description(value="apoc.create.vRelationship(nodeFrom,'KNOWS',{key:value,...}, nodeTo) returns a virtual relationship")
    public Stream<RelationshipResult> vRelationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return Stream.of(new RelationshipResult(this.vRelationshipFunction(from, relType, props, to)));
    }

    @UserFunction(value="apoc.create.vRelationship")
    @Description(value="apoc.create.vRelationship(nodeFrom,'KNOWS',{key:value,...}, nodeTo) returns a virtual relationship")
    public Relationship vRelationshipFunction(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return new VirtualRelationship(from, to, RelationshipType.withName((String)relType)).withProperties(props);
    }

    @Procedure(deprecatedBy="apoc.create.virtualPath")
    @Deprecated
    @Description(value="apoc.create.vPattern({_labels:['LabelA'],key:value},'KNOWS',{key:value,...}, {_labels:['LabelB'],key:value}) returns a virtual pattern")
    public Stream<VirtualPathResult> vPattern(@Name(value="from") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Map<String, Object> m) {
        n = new LinkedHashMap<String, Object>(n);
        m = new LinkedHashMap<String, Object>(m);
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(Util.labels(n.remove("_labels")), n);
        VirtualNode to = new VirtualNode(Util.labels(m.remove("_labels")), m);
        Relationship rel = new VirtualRelationship(from, to, RelationshipType.withName((String)relType)).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    @Procedure(deprecatedBy="apoc.create.virtualPath")
    @Deprecated
    @Description(value="apoc.create.vPatternFull(['LabelA'],{key:value},'KNOWS',{key:value,...},['LabelB'],{key:value}) returns a virtual pattern")
    public Stream<VirtualPathResult> vPatternFull(@Name(value="labelsN") List<String> labelsN, @Name(value="n") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="labelsM") List<String> labelsM, @Name(value="m") Map<String, Object> m) {
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(Util.labels(labelsN), n);
        VirtualNode to = new VirtualNode(Util.labels(labelsM), m);
        Relationship rel = new VirtualRelationship(from, to, type).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    @Procedure
    @Description(value="apoc.create.virtualPath(['LabelA'],{key:value},'KNOWS',{key:value,...},['LabelB'],{key:value}) returns a virtual path of nodes joined by a relationship and the associated properties")
    public Stream<VirtualPathResult> virtualPath(@Name(value="labelsN") List<String> labelsN, @Name(value="n") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="labelsM") List<String> labelsM, @Name(value="m") Map<String, Object> m) {
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(Util.labels(labelsN), n);
        VirtualNode to = new VirtualNode(Util.labels(labelsM), m);
        Relationship rel = new VirtualRelationship(from, to, type).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    private <T extends Entity> T setProperties(T pc, Map<String, Object> p) {
        if (p == null) {
            return pc;
        }
        for (Map.Entry<String, Object> entry : p.entrySet()) {
            this.setProperty(pc, entry.getKey(), entry.getValue());
        }
        return pc;
    }

    private <T extends Entity> void setProperty(T pc, String key, Object value) {
        if (value == null) {
            pc.removeProperty(key);
        } else {
            pc.setProperty(key, this.toPropertyValue(value));
        }
    }

    @UserFunction
    @Description(value="apoc.create.uuid() - creates an UUID")
    public String uuid() {
        return UUID.randomUUID().toString();
    }

    private Object toPropertyValue(Object value) {
        if (value instanceof Iterable) {
            Iterable it = (Iterable)value;
            Object first = Iterables.firstOrNull((Iterable)it);
            if (first == null) {
                return EMPTY_ARRAY;
            }
            return Iterables.asArray(first.getClass(), (Iterable)it);
        }
        return value;
    }

    @Procedure
    @Description(value="apoc.create.uuids(count) yield uuid - creates 'count' UUIDs ")
    public Stream<UUIDResult> uuids(@Name(value="count") long count) {
        return LongStream.range(0L, count).mapToObj(UUIDResult::new);
    }

    public static class UUIDResult {
        public final long row;
        public final String uuid;

        public UUIDResult(long row) {
            this.row = row;
            this.uuid = UUID.randomUUID().toString();
        }
    }
}

