/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvHeaderField;
import apoc.export.csv.CsvHeaderFields;
import apoc.export.csv.CsvLoaderConfig;
import apoc.export.csv.CsvLoaderConstants;
import apoc.export.csv.CsvPropertyConverter;
import apoc.export.util.BatchTransaction;
import apoc.export.util.CountingReader;
import apoc.export.util.ProgressReporter;
import apoc.load.CSVResult;
import apoc.load.Mapping;
import apoc.load.util.Results;
import apoc.util.FileUtils;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.logging.Log;

public class CsvEntityLoader {
    private final CsvLoaderConfig clc;
    private final ProgressReporter reporter;
    private final Log log;

    public CsvEntityLoader(CsvLoaderConfig clc, ProgressReporter reporter, Log log) {
        this.clc = clc;
        this.reporter = reporter;
        this.log = log;
    }

    public void loadNodes(String fileName, List<String> labels2, GraphDatabaseService db, Map<String, Map<String, Long>> idMapping) throws IOException {
        CountingReader reader = FileUtils.readerFor(fileName);
        String header = CsvEntityLoader.readFirstLine(reader);
        reader.skip(this.clc.getSkipLines() - 1);
        List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
        Optional<CsvHeaderField> idField = fields.stream().filter(f -> "ID".equals(f.getType())).findFirst();
        if (!idField.isPresent()) {
            this.log.warn("Please note that if no ID is specified, the node will be imported but it will not be able to be connected by any relationships during the import");
        }
        Optional<String> idAttribute = idField.isPresent() ? Optional.of(idField.get().getName()) : Optional.empty();
        String idSpace = idField.isPresent() ? idField.get().getIdSpace() : "__CSV_DEFAULT_IDSPACE";
        idMapping.putIfAbsent(idSpace, new HashMap());
        Map<String, Long> idspaceIdMapping = idMapping.get(idSpace);
        Map<String, Mapping> mapping = fields.stream().collect(Collectors.toMap(CsvHeaderField::getName, f -> {
            Map<String, Object> mappingMap = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("type", f.getType()), new AbstractMap.SimpleEntry<String, Boolean>("array", f.isArray())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            return new Mapping(f.getName(), mappingMap, this.clc.getArrayDelimiter(), false);
        }));
        CSVReader csv = new CSVReader((Reader)reader, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
        String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
        int lineNo = 0;
        try (BatchTransaction btx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
            for (Object[] objectArray : csv.readAll()) {
                EnumSet<Results> results = EnumSet.of(Results.map);
                CSVResult result = new CSVResult(loadCsvCompatibleHeader, (String[])objectArray, ++lineNo, false, mapping, Collections.emptyList(), results);
                String nodeCsvId = idAttribute.map(result.map::get).orElse(null);
                if (idField.isPresent() && idspaceIdMapping.containsKey(nodeCsvId)) {
                    if (this.clc.getIgnoreDuplicateNodes()) continue;
                    throw new IllegalStateException("Duplicate node with id " + nodeCsvId + " found on line " + lineNo + "\n" + Arrays.toString(objectArray));
                }
                Node node = btx.getTransaction().createNode();
                if (idField.isPresent()) {
                    idspaceIdMapping.put(nodeCsvId, node.getId());
                }
                for (String label : labels2) {
                    node.addLabel(Label.label((String)label));
                }
                int props = 0;
                for (CsvHeaderField field : fields) {
                    String name = field.getName();
                    Object value = result.map.get(name);
                    if (field.isMeta()) {
                        List customLabels = (List)value;
                        for (String customLabel : customLabels) {
                            node.addLabel(Label.label((String)customLabel));
                        }
                        continue;
                    }
                    if (field.isId()) {
                        Object idValue = this.clc.getStringIds() ? value : Long.valueOf((String)value);
                        node.setProperty(field.getName(), idValue);
                        ++props;
                        continue;
                    }
                    boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)node, field, value);
                    props += propertyAdded ? 1 : 0;
                }
                this.reporter.update(1L, 0L, props++);
            }
        }
    }

    public void loadRelationships(String fileName, String type, GraphDatabaseService db, Map<String, Map<String, Long>> idMapping) throws IOException {
        CountingReader reader = FileUtils.readerFor(fileName);
        String header = CsvEntityLoader.readFirstLine(reader);
        List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
        CsvHeaderField startIdField = fields.stream().filter(f -> "START_ID".equals(f.getType())).findFirst().get();
        CsvHeaderField endIdField = fields.stream().filter(f -> "END_ID".equals(f.getType())).findFirst().get();
        List edgePropertiesFields = fields.stream().filter(field -> !"START_ID".equals(field.getType())).filter(field -> !"END_ID".equals(field.getType())).collect(Collectors.toList());
        Map<String, Mapping> mapping = fields.stream().collect(Collectors.toMap(CsvHeaderField::getName, f -> {
            Map<String, Object> mappingMap = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("type", f.getType()), new AbstractMap.SimpleEntry<String, Boolean>("array", f.isArray())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            return new Mapping(f.getName(), mappingMap, this.clc.getArrayDelimiter(), false);
        }));
        CSVReader csv = new CSVReader(reader, this.clc.getDelimiter());
        String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
        int lineNo = 0;
        try (BatchTransaction btx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
            for (String[] line : csv.readAll()) {
                EnumSet<Results> results = EnumSet.of(Results.map);
                CSVResult result = new CSVResult(loadCsvCompatibleHeader, line, ++lineNo, false, mapping, Collections.emptyList(), results);
                Object startId = result.map.get(CsvLoaderConstants.START_ID_ATTR);
                Long startInternalId = idMapping.get(startIdField.getIdSpace()).get(startId);
                if (startInternalId == null) {
                    throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + startId + " not found");
                }
                Node source = btx.getTransaction().getNodeById(startInternalId.longValue());
                Object endId = result.map.get(CsvLoaderConstants.END_ID_ATTR);
                Long endInternalId = idMapping.get(endIdField.getIdSpace()).get(endId);
                if (endInternalId == null) {
                    throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + endId + " not found");
                }
                Node target = btx.getTransaction().getNodeById(endInternalId.longValue());
                Object overridingType = result.map.get(CsvLoaderConstants.TYPE_ATTR);
                String currentType = overridingType != null && !((String)overridingType).isEmpty() ? (String)overridingType : type;
                Relationship rel = source.createRelationshipTo(target, RelationshipType.withName((String)currentType));
                int props = 0;
                for (CsvHeaderField field2 : edgePropertiesFields) {
                    String name;
                    Object value;
                    boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)rel, field2, value = result.map.get(name = field2.getName()));
                    props += propertyAdded ? 1 : 0;
                }
                this.reporter.update(0L, 1L, props);
            }
        }
    }

    private static String readFirstLine(CountingReader reader) throws IOException {
        char c;
        int i;
        Object line = "";
        while ((i = reader.read()) != 0 && (c = (char)i) != '\n') {
            line = (String)line + c;
        }
        return line;
    }
}

