/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvHeaderField;
import java.util.List;
import org.neo4j.graphdb.Entity;

public class CsvPropertyConverter {
    public static boolean addPropertyToGraphEntity(Entity entity, CsvHeaderField field, Object value) {
        if (field.isIgnore()) {
            return false;
        }
        if (field.isArray()) {
            Object[] prototype = CsvPropertyConverter.getPrototypeFor(field.getType());
            Object[] array = ((List)value).toArray(prototype);
            entity.setProperty(field.getName(), (Object)array);
        } else {
            entity.setProperty(field.getName(), value);
        }
        return true;
    }

    static Object[] getPrototypeFor(String type) {
        switch (type) {
            case "INT": {
                return new Integer[0];
            }
            case "LONG": {
                return new Long[0];
            }
            case "FLOAT": {
                return new Float[0];
            }
            case "DOUBLE": {
                return new Double[0];
            }
            case "BOOLEAN": {
                return new Boolean[0];
            }
            case "BYTE": {
                return new Byte[0];
            }
            case "SHORT": {
                return new Short[0];
            }
            case "CHAR": {
                return new Character[0];
            }
            case "STRING": {
                return new String[0];
            }
        }
        throw new IllegalStateException("Type " + type + " not supported.");
    }
}

