/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.Pools;
import apoc.export.csv.CsvEntityLoader;
import apoc.export.csv.CsvLoaderConfig;
import apoc.export.util.ProgressReporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ImportCsv {
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public Log log;

    public ImportCsv(GraphDatabaseService db) {
        this.db = db;
    }

    public ImportCsv() {
    }

    @Procedure(name="apoc.import.csv", mode=Mode.SCHEMA)
    @Description(value="apoc.import.csv(nodes, relationships, config) - imports nodes and relationships from the provided CSV files with given labels and types")
    public Stream<ProgressInfo> importCsv(@Name(value="nodes") List<Map<String, Object>> nodes, @Name(value="relationships") List<Map<String, String>> relationships, @Name(value="config") Map<String, Object> config) throws Exception {
        ProgressInfo result = Util.inThread(this.pools, () -> {
            String fileName;
            ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo("progress.csv", "file", "csv"));
            CsvLoaderConfig clc = CsvLoaderConfig.from(config);
            CsvEntityLoader loader = new CsvEntityLoader(clc, reporter, this.log);
            HashMap<String, Map<String, Long>> idMapping = new HashMap<String, Map<String, Long>>();
            for (Map node : nodes) {
                fileName = (String)node.get("fileName");
                List labels2 = (List)node.get("labels");
                loader.loadNodes(fileName, labels2, this.db, idMapping);
            }
            for (Map relationship : relationships) {
                fileName = (String)relationship.get("fileName");
                String type = (String)relationship.get("type");
                loader.loadRelationships(fileName, type, this.db, idMapping);
            }
            return reporter.getTotal();
        });
        return Stream.of(result);
    }
}

