/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.cypher.MultiStatementCypherSubGraphExporter;
import apoc.export.util.ExportConfig;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.result.ProgressInfo;
import apoc.util.QueueBasedSpliterator;
import apoc.util.QueueUtil;
import apoc.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportCypher {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;

    public ExportCypher(GraphDatabaseService db) {
        this.db = db;
    }

    public ExportCypher() {
    }

    @Procedure
    @Description(value="apoc.export.cypher.all(file,config) - exports whole database incl. indexes as cypher statements to the provided file")
    public Stream<DataProgressInfo> all(@Name(value="file", defaultValue="") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (Util.isNullOrEmpty(fileName)) {
            fileName = null;
        }
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportCypher(fileName, source, new DatabaseSubGraph(this.tx), new ExportConfig(config), false);
    }

    @Procedure
    @Description(value="apoc.export.cypher.data(nodes,rels,file,config) - exports given nodes and relationships incl. indexes as cypher statements to the provided file")
    public Stream<DataProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file", defaultValue="") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (Util.isNullOrEmpty(fileName)) {
            fileName = null;
        }
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCypher(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config), false);
    }

    @Procedure
    @Description(value="apoc.export.cypher.graph(graph,file,config) - exports given graph object incl. indexes as cypher statements to the provided file")
    public Stream<DataProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file", defaultValue="") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (Util.isNullOrEmpty(fileName)) {
            fileName = null;
        }
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCypher(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config), false);
    }

    @Procedure
    @Description(value="apoc.export.cypher.query(query,file,config) - exports nodes and relationships from the cypher statement incl. indexes as cypher statements to the provided file")
    public Stream<DataProgressInfo> query(@Name(value="query") String query, @Name(value="file", defaultValue="") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        SubGraph graph;
        if (Util.isNullOrEmpty(fileName)) {
            fileName = null;
        }
        ExportConfig c = new ExportConfig(config);
        Result result = this.tx.execute(query);
        try {
            graph = CypherResultSubGraph.from(this.tx, result, c.getRelsInBetween());
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Full-text indexes on relationships are not supported, please delete them in order to complete the process");
        }
        String source = String.format("statement: nodes(%d), rels(%d)", Iterables.count(graph.getNodes()), Iterables.count(graph.getRelationships()));
        return this.exportCypher(fileName, source, graph, c, false);
    }

    @Procedure
    @Description(value="apoc.export.cypher.schema(file,config) - exports all schema indexes and constraints to cypher")
    public Stream<DataProgressInfo> schema(@Name(value="file", defaultValue="") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (Util.isNullOrEmpty(fileName)) {
            fileName = null;
        }
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportCypher(fileName, source, new DatabaseSubGraph(this.tx), new ExportConfig(config), true);
    }

    private Stream<DataProgressInfo> exportCypher(@Name(value="file") String fileName, String source, SubGraph graph, ExportConfig c, boolean onlySchema) throws IOException {
        if (StringUtils.isNotBlank(fileName)) {
            this.apocConfig.checkWriteAllowed(c);
        }
        ProgressInfo progressInfo = new ProgressInfo(fileName, source, "cypher");
        progressInfo.batchSize = c.getBatchSize();
        ProgressReporter reporter = new ProgressReporter(null, null, progressInfo);
        boolean separatedFiles = !onlySchema && c.separateFiles();
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, separatedFiles);
        if (c.streamStatements()) {
            long timeout = c.getTimeoutSeconds();
            ArrayBlockingQueue queue = new ArrayBlockingQueue(1000);
            ProgressReporter reporterWithConsumer = reporter.withConsumer(pi -> QueueUtil.put(queue, pi == ProgressInfo.EMPTY ? DataProgressInfo.EMPTY : new DataProgressInfo((ProgressInfo)pi).enrich(cypherFileManager), timeout));
            Util.inTxFuture(this.pools.getDefaultExecutorService(), this.db, txInThread -> {
                this.doExport(graph, c, onlySchema, reporterWithConsumer, cypherFileManager);
                return true;
            });
            QueueBasedSpliterator<DataProgressInfo> spliterator = new QueueBasedSpliterator<DataProgressInfo>(queue, DataProgressInfo.EMPTY, this.terminationGuard, Integer.MAX_VALUE);
            return StreamSupport.stream(spliterator, false);
        }
        this.doExport(graph, c, onlySchema, reporter, cypherFileManager);
        return reporter.stream().map(DataProgressInfo::new).map(dpi -> dpi.enrich(cypherFileManager));
    }

    private void doExport(SubGraph graph, ExportConfig c, boolean onlySchema, ProgressReporter reporter, ExportFileManager cypherFileManager) {
        MultiStatementCypherSubGraphExporter exporter = new MultiStatementCypherSubGraphExporter(graph, c, this.db);
        if (onlySchema) {
            exporter.exportOnlySchema(cypherFileManager);
        } else {
            exporter.export(c, reporter, cypherFileManager);
        }
    }

    public static class DataProgressInfo {
        public final String file;
        public final long batches;
        public String source;
        public final String format;
        public long nodes;
        public long relationships;
        public long properties;
        public long time;
        public long rows;
        public long batchSize;
        public String cypherStatements;
        public String nodeStatements;
        public String relationshipStatements;
        public String schemaStatements;
        public String cleanupStatements;
        public static final DataProgressInfo EMPTY = new DataProgressInfo(ProgressInfo.EMPTY);

        public DataProgressInfo(ProgressInfo pi) {
            this.file = pi.file;
            this.format = pi.format;
            this.source = pi.source;
            this.nodes = pi.nodes;
            this.relationships = pi.relationships;
            this.properties = pi.properties;
            this.time = pi.time;
            this.rows = pi.rows;
            this.batchSize = pi.batchSize;
            this.batches = pi.batches;
        }

        public DataProgressInfo enrich(ExportFileManager fileInfo) {
            this.cypherStatements = fileInfo.drain("cypher");
            this.nodeStatements = fileInfo.drain("nodes");
            this.relationshipStatements = fileInfo.drain("relationships");
            this.schemaStatements = fileInfo.drain("schema");
            this.cleanupStatements = fileInfo.drain("cleanup");
            return this;
        }
    }
}

