/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.graphml.XmlGraphMLReader;
import apoc.export.graphml.XmlGraphMLWriter;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportGraphML {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;

    @Procedure(name="apoc.import.graphml", mode=Mode.WRITE)
    @Description(value="apoc.import.graphml(file,config) - imports graphml file")
    public Stream<ProgressInfo> file(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        ProgressInfo result = Util.inThread(this.pools, () -> {
            ExportConfig exportConfig = new ExportConfig(config);
            ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(fileName, "file", "graphml"));
            XmlGraphMLReader graphMLReader = new XmlGraphMLReader(this.db, this.tx).reporter(reporter).batchSize(exportConfig.getBatchSize()).relType(exportConfig.defaultRelationshipType()).nodeLabels(exportConfig.readLabels());
            if (exportConfig.storeNodeIds()) {
                graphMLReader.storeNodeIds();
            }
            graphMLReader.parseXML(FileUtils.readerFor(fileName));
            return reporter.getTotal();
        });
        return Stream.of(result);
    }

    @Procedure
    @Description(value="apoc.export.graphml.all(file,config) - exports whole database as graphml to the provided file")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportGraphML(fileName, source, new DatabaseSubGraph(this.tx), new ExportConfig(config));
    }

    @Procedure
    @Description(value="apoc.export.graphml.data(nodes,rels,file,config) - exports given nodes and relationships as graphml to the provided file")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportGraphML(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config));
    }

    @Procedure
    @Description(value="apoc.export.graphml.graph(graph,file,config) - exports given graph object as graphml to the provided file")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportGraphML(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config));
    }

    @Procedure
    @Description(value="apoc.export.graphml.query(query,file,config) - exports nodes and relationships from the cypher statement as graphml to the provided file")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        ExportConfig c = new ExportConfig(config);
        Result result = this.tx.execute(query);
        SubGraph graph = CypherResultSubGraph.from(this.tx, result, c.getRelsInBetween());
        String source = String.format("statement: nodes(%d), rels(%d)", Iterables.count(graph.getNodes()), Iterables.count(graph.getRelationships()));
        return this.exportGraphML(fileName, source, graph, c);
    }

    private Stream<ProgressInfo> exportGraphML(@Name(value="file") String fileName, String source, SubGraph graph, ExportConfig exportConfig) throws Exception {
        if (StringUtils.isNotBlank(fileName)) {
            this.apocConfig.checkWriteAllowed(exportConfig);
        }
        String format = "graphml";
        ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(fileName, source, "graphml"));
        XmlGraphMLWriter exporter = new XmlGraphMLWriter();
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, false);
        PrintWriter graphMl = cypherFileManager.getPrintWriter("graphml");
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "graphml", exportConfig, reporter, cypherFileManager, reporterWithConsumer -> {
                try {
                    exporter.write(graph, graphMl, (Reporter)reporterWithConsumer, exportConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        exporter.write(graph, graphMl, reporter, exportConfig);
        this.closeWriter(graphMl);
        return reporter.stream();
    }

    private void closeWriter(PrintWriter writer) {
        writer.flush();
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

