/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.export.json.ImportJsonConfig;
import apoc.export.util.Reporter;
import apoc.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class JsonImporter
implements Closeable {
    private static final String CREATE_NODE = "UNWIND $rows AS row CREATE (n%s {%s: row.id}) SET n += row.properties";
    private static final String CREATE_RELS = "UNWIND $rows AS row MATCH (s%s {%s: row.start.id}) MATCH (e%s {%2$s: row.end.id}) CREATE (s)-[r:%s]->(e) SET r += row.properties";
    private final List<Map<String, Object>> paramList;
    private final int unwindBatchSize;
    private final int txBatchSize;
    private final GraphDatabaseService db;
    private final Reporter reporter;
    private String lastType;
    private List<String> lastLabels;
    private Map<String, Object> lastRelTypes;
    private final ImportJsonConfig importJsonConfig;

    public JsonImporter(ImportJsonConfig importJsonConfig, GraphDatabaseService db, Reporter reporter) {
        this.paramList = new ArrayList<Map<String, Object>>(importJsonConfig.getUnwindBatchSize());
        this.db = db;
        this.txBatchSize = importJsonConfig.getTxBatchSize();
        this.unwindBatchSize = Math.min(importJsonConfig.getUnwindBatchSize(), this.txBatchSize);
        this.reporter = reporter;
        this.importJsonConfig = importJsonConfig;
    }

    public void importRow(Map<String, Object> param) {
        String type = (String)param.get("type");
        this.manageEntityType(type);
        switch (type) {
            case "node": {
                this.manageNode(param);
                break;
            }
            case "relationship": {
                this.manageRelationship(param);
                break;
            }
            default: {
                throw new IllegalArgumentException("Current type not supported: " + type);
            }
        }
        Map<String, Object> properties = param.getOrDefault("properties", Collections.emptyMap());
        this.updateReporter(type, properties);
        param.put("properties", this.convertProperties(type, properties, null));
        this.paramList.add(param);
        if (this.paramList.size() % this.txBatchSize == 0) {
            Collection<List<Map<String, Object>>> results = this.chunkData();
            this.paramList.clear();
            this.writeUnwindBatch(results);
        }
    }

    private void writeUnwindBatch(Collection<List<Map<String, Object>>> results) {
        try (Transaction tx = this.db.beginTx();){
            results.forEach(resultList -> {
                if (resultList.size() == this.unwindBatchSize) {
                    this.write(tx, (List<Map<String, Object>>)resultList);
                } else {
                    this.paramList.addAll((Collection<Map<String, Object>>)resultList);
                }
            });
            tx.close();
        }
    }

    private void manageEntityType(String type) {
        if (this.lastType == null) {
            this.lastType = type;
        }
        if (!type.equals(this.lastType)) {
            this.flush();
            this.lastType = type;
        }
    }

    private void manageRelationship(Map<String, Object> param) {
        Map<String, Object> relType = Util.map("start", this.getLabels((Map)param.get("start")), "end", this.getLabels((Map)param.get("end")), "label", this.getType(param));
        if (this.lastRelTypes == null) {
            this.lastRelTypes = relType;
        }
        if (!relType.equals(this.lastRelTypes)) {
            this.flush();
            this.lastRelTypes = relType;
        }
    }

    private void manageNode(Map<String, Object> param) {
        List<String> labels2 = this.getLabels(param);
        if (this.lastLabels == null) {
            this.lastLabels = labels2;
        }
        if (!labels2.equals(this.lastLabels)) {
            this.flush();
            this.lastLabels = labels2;
        }
    }

    private void updateReporter(String type, Map<String, Object> properties) {
        int size = properties.size() + 1;
        switch (type) {
            case "node": {
                this.reporter.update(1L, 0L, size);
                break;
            }
            case "relationship": {
                this.reporter.update(0L, 1L, size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Current type not supported: " + type);
            }
        }
    }

    private Stream<Map.Entry<String, Object>> flatMap(Map<String, Object> map, String key) {
        String prefix = key != null ? key : "";
        return map.entrySet().stream().flatMap(e -> {
            if (e.getValue() instanceof Map) {
                return this.flatMap((Map)e.getValue(), prefix + "." + (String)e.getKey());
            }
            return Stream.of(new AbstractMap.SimpleEntry((CallSite)((Object)(prefix + "." + (String)e.getKey())), e.getValue()));
        });
    }

    private List<Object> convertList(Collection<Object> coll, String classType) {
        return coll.stream().map(c -> {
            if (c instanceof Collection) {
                return this.convertList((Collection)c, classType);
            }
            return this.convertMappedValue(c, classType);
        }).collect(Collectors.toList());
    }

    private Map<String, Object> convertProperties(String type, Map<String, Object> properties, String keyPrefix) {
        return properties.entrySet().stream().flatMap(e -> {
            if (e.getValue() instanceof Map) {
                Map map = (Map)e.getValue();
                String classType = this.getClassType(type, (String)e.getKey());
                if (classType != null && "POINT".equals(classType.toUpperCase())) {
                    return Stream.of(e);
                }
                return this.flatMap(map, (String)e.getKey());
            }
            return Stream.of(e);
        }).map(e -> {
            String key = (String)e.getKey();
            String classType = this.getClassType(type, key);
            if (e.getValue() instanceof Collection) {
                List<Object> coll = this.convertList((Collection)e.getValue(), classType);
                return new AbstractMap.SimpleEntry<String, List<Object>>((String)e.getKey(), coll);
            }
            return new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), this.convertMappedValue(e.getValue(), classType));
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    private String getClassType(String type, String key) {
        String classType;
        switch (type) {
            case "node": {
                classType = this.importJsonConfig.typeForNode(this.lastLabels, key);
                break;
            }
            case "relationship": {
                classType = this.importJsonConfig.typeForRel((String)this.lastRelTypes.get("label"), key);
                break;
            }
            default: {
                classType = null;
            }
        }
        return classType;
    }

    private Object convertMappedValue(Object value, String classType) {
        if (classType == null) {
            return value;
        }
        switch (classType.toUpperCase()) {
            case "POINT": {
                value = this.toPoint((Map)value);
                break;
            }
            case "LOCALDATE": {
                value = LocalDate.parse((String)value);
                break;
            }
            case "LOCALTIME": {
                value = LocalTime.parse((String)value);
                break;
            }
            case "LOCALDATETIME": {
                value = LocalDateTime.parse((String)value);
                break;
            }
            case "DURATION": {
                value = DurationValue.parse((CharSequence)((String)value));
                break;
            }
            case "OFFSETTIME": {
                value = OffsetTime.parse((String)value);
                break;
            }
            case "ZONEDDATETIME": {
                value = ZonedDateTime.parse((String)value);
                break;
            }
        }
        return value;
    }

    private PointValue toPoint(Map<String, Object> pointMap) {
        double y;
        double x;
        Double z = null;
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.byName((String)((String)pointMap.get("crs")));
        if (crs.getName().startsWith("wgs-84")) {
            x = (Double)pointMap.get("latitude");
            y = (Double)pointMap.get("longitude");
            if (crs.getName().endsWith("-3d")) {
                z = (double)((Double)pointMap.get("height"));
            }
        } else {
            x = (Double)pointMap.get("x");
            y = (Double)pointMap.get("y");
            if (crs.getName().endsWith("-3d")) {
                z = (double)((Double)pointMap.get("z"));
            }
        }
        return z != null ? Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y, z}) : Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y});
    }

    private String getType(Map<String, Object> param) {
        return Util.quote((String)param.get("label"));
    }

    private List<String> getLabels(Map<String, Object> param) {
        return param.getOrDefault("labels", Collections.emptyList()).stream().map(Util::quote).collect(Collectors.toList());
    }

    private String getLabelString(List<String> labels2) {
        labels2 = labels2 == null ? Collections.emptyList() : labels2;
        String join = StringUtils.join(labels2, ":");
        return join.isBlank() ? join : ":" + join;
    }

    private void write(Transaction tx, List<Map<String, Object>> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        String type = (String)resultList.get(0).get("type");
        String query = null;
        switch (type) {
            case "node": {
                query = String.format(CREATE_NODE, this.getLabelString(this.lastLabels), this.importJsonConfig.getImportIdName());
                break;
            }
            case "relationship": {
                String rel = (String)this.lastRelTypes.get("label");
                query = String.format(CREATE_RELS, this.getLabelString((List)this.lastRelTypes.get("start")), this.importJsonConfig.getImportIdName(), this.getLabelString((List)this.lastRelTypes.get("end")), rel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Current type not supported: " + type);
            }
        }
        if (StringUtils.isNotBlank(query)) {
            this.db.executeTransactionally(query, Collections.singletonMap("rows", resultList));
        }
    }

    private Collection<List<Map<String, Object>>> chunkData() {
        AtomicInteger chunkCounter = new AtomicInteger(0);
        return this.paramList.stream().collect(Collectors.groupingBy(it -> chunkCounter.getAndIncrement() / this.unwindBatchSize)).values();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.reporter.done();
    }

    private void flush() {
        if (!this.paramList.isEmpty()) {
            Collection<List<Map<String, Object>>> results = this.chunkData();
            try (Transaction tx = this.db.beginTx();){
                results.forEach(resultList -> this.write(tx, (List<Map<String, Object>>)resultList));
            }
            this.paramList.clear();
        }
    }
}

