/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.InvalidConfigException;
import apoc.generate.config.RelationshipGeneratorConfig;
import apoc.generate.relationship.RelationshipGenerator;
import java.util.List;
import org.neo4j.internal.helpers.collection.Pair;

public abstract class BaseRelationshipGenerator<T extends RelationshipGeneratorConfig>
implements RelationshipGenerator {
    private final T configuration;

    protected BaseRelationshipGenerator(T configuration) {
        this.configuration = configuration;
    }

    @Override
    public int getNumberOfNodes() {
        return this.configuration.getNumberOfNodes();
    }

    @Override
    public List<Pair<Integer, Integer>> generateEdges() throws InvalidConfigException {
        if (!this.configuration.isValid()) {
            throw new InvalidConfigException("The supplied config is not valid");
        }
        return this.doGenerateEdges();
    }

    protected abstract List<Pair<Integer, Integer>> doGenerateEdges();

    protected T getConfiguration() {
        return this.configuration;
    }
}

