/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.WattsStrogatzConfig;
import apoc.generate.relationship.BaseRelationshipGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.neo4j.internal.helpers.collection.Pair;

public class WattsStrogatzRelationshipGenerator
extends BaseRelationshipGenerator<WattsStrogatzConfig> {
    private Random random = new Random();

    public WattsStrogatzRelationshipGenerator(WattsStrogatzConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<Pair<Integer, Integer>> doGenerateEdges() {
        int numberOfNodes = ((WattsStrogatzConfig)this.getConfiguration()).getNumberOfNodes();
        int meanDegree = ((WattsStrogatzConfig)this.getConfiguration()).getMeanDegree();
        double beta = ((WattsStrogatzConfig)this.getConfiguration()).getBeta();
        HashSet<Object> ring = new HashSet<Object>(numberOfNodes);
        for (int i = 0; i < numberOfNodes; ++i) {
            for (int j = i + 1; j <= i + meanDegree / 2; ++j) {
                int friend = j % numberOfNodes;
                ring.add(Pair.of((Object)i, (Object)friend));
            }
        }
        HashSet<Pair> newEdges = new HashSet<Pair>();
        Iterator iterator = ring.iterator();
        block2: while (iterator.hasNext()) {
            Pair trialPair;
            Pair edge = (Pair)iterator.next();
            if (!(this.random.nextDouble() <= beta)) continue;
            int choice = this.random.nextDouble() > 0.5 ? (Integer)edge.first() : (Integer)edge.other();
            do {
                int trial;
                int partner;
                int n = partner = (trial = this.random.nextInt(numberOfNodes - 1)) < choice ? trial : trial + 1;
                trialPair = Pair.of((Object)choice, (Object)partner);
                if (trialPair.equals((Object)edge)) continue block2;
            } while (ring.contains(trialPair) || newEdges.contains(trialPair));
            iterator.remove();
            newEdges.add(trialPair);
        }
        ring.addAll(newEdges);
        return new ArrayList<Pair<Integer, Integer>>(ring);
    }
}

