/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.meta.Meta;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Mapping {
    public static final Mapping EMPTY = new Mapping("", Collections.emptyMap(), ';', false);
    final String name;
    final Collection<String> nullValues;
    final Meta.Types type;
    final boolean array;
    final boolean ignore;
    final char arraySep;
    private final Pattern arrayPattern;

    public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
        this.name = mapping.getOrDefault("name", name).toString();
        this.array = (Boolean)mapping.getOrDefault("array", false);
        this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
        this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
        this.arraySep = Util.parseCharFromConfig(mapping, "arraySep", arraySep);
        this.type = Meta.Types.from(mapping.getOrDefault("type", "STRING").toString());
        this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
        if (this.type == null) {
            throw new RuntimeException("In specified mapping, there is no type by the name " + mapping.getOrDefault("type", "STRING").toString());
        }
    }

    public Object convert(String value) {
        return this.array ? this.convertArray(value) : this.convertType(value);
    }

    private Object convertArray(String value) {
        String[] values = this.arrayPattern.split(value);
        ArrayList<Object> result = new ArrayList<Object>(values.length);
        for (String v : values) {
            result.add(this.convertType(v));
        }
        return result;
    }

    private Object convertType(String value) {
        if (this.nullValues.contains(value)) {
            return null;
        }
        if (this.type == Meta.Types.STRING) {
            return value;
        }
        switch (this.type) {
            case INTEGER: {
                return Util.toLong(value);
            }
            case FLOAT: {
                return Util.toDouble(value);
            }
            case BOOLEAN: {
                return Util.toBoolean(value);
            }
            case NULL: {
                return null;
            }
            case LIST: {
                return Arrays.stream(this.arrayPattern.split(value)).map(this::convertType).collect(Collectors.toList());
            }
        }
        return value;
    }
}

