/*
 * Decompiled with CFR 0.152.
 */
package apoc.merge;

import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Merge {
    @Context
    public Transaction tx;

    @Procedure(value="apoc.merge.node.eager", mode=Mode.WRITE, eager=true)
    @Description(value="apoc.merge.node.eager(['Label'], identProps:{key:value, ...}, onCreateProps:{key:value,...}, onMatchProps:{key:value,...}}) - merge nodes eagerly, with dynamic labels, with support for setting properties ON CREATE or ON MATCH")
    public Stream<NodeResult> nodesEager(@Name(value="label") List<String> labelNames, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props", defaultValue="{}") Map<String, Object> props, @Name(value="onMatchProps", defaultValue="{}") Map<String, Object> onMatchProps) {
        return this.nodes(labelNames, identProps, props, onMatchProps);
    }

    @Procedure(value="apoc.merge.node", mode=Mode.WRITE)
    @Description(value="\"apoc.merge.node.eager(['Label'], identProps:{key:value, ...}, onCreateProps:{key:value,...}, onMatchProps:{key:value,...}}) - merge nodes with dynamic labels, with support for setting properties ON CREATE or ON MATCH")
    public Stream<NodeResult> nodes(@Name(value="label") List<String> labelNames, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props", defaultValue="{}") Map<String, Object> props, @Name(value="onMatchProps", defaultValue="{}") Map<String, Object> onMatchProps) {
        if (identProps == null || identProps.isEmpty()) {
            throw new IllegalArgumentException("you need to supply at least one identifying property for a merge");
        }
        String labels2 = Util.labelString(labelNames);
        Map<String, Object> params = Util.map("identProps", identProps, "onCreateProps", props, "onMatchProps", onMatchProps);
        String identPropsString = this.buildIdentPropsString(identProps);
        String cypher = "MERGE (n:" + labels2 + "{" + identPropsString + "}) ON CREATE SET n += $onCreateProps ON MATCH SET n += $onMatchProps RETURN n";
        return this.tx.execute(cypher, params).columnAs("n").stream().map(node -> new NodeResult((Node)node));
    }

    @Procedure(value="apoc.merge.relationship", mode=Mode.WRITE)
    @Description(value="apoc.merge.relationship(startNode, relType,  identProps:{key:value, ...}, onCreateProps:{key:value, ...}, endNode, onMatchProps:{key:value, ...}) - merge relationship with dynamic type, with support for setting properties ON CREATE or ON MATCH")
    public Stream<RelationshipResult> relationship(@Name(value="startNode") Node startNode, @Name(value="relationshipType") String relType, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props") Map<String, Object> onCreateProps, @Name(value="endNode") Node endNode, @Name(value="onMatchProps", defaultValue="{}") Map<String, Object> onMatchProps) {
        String identPropsString = this.buildIdentPropsString(identProps);
        Map<String, Object> params = Util.map("identProps", identProps, "onCreateProps", onCreateProps == null ? Collections.emptyMap() : onCreateProps, "onMatchProps", onMatchProps == null ? Collections.emptyMap() : onMatchProps, "startNode", startNode, "endNode", endNode);
        String cypher = "WITH $startNode as startNode, $endNode as endNode MERGE (startNode)-[r:" + Util.quote(relType) + "{" + identPropsString + "}]->(endNode) ON CREATE SET r+= $onCreateProps ON MATCH SET r+= $onMatchProps RETURN r";
        return this.tx.execute(cypher, params).columnAs("r").stream().map(rel -> new RelationshipResult((Relationship)rel));
    }

    @Procedure(value="apoc.merge.relationship.eager", mode=Mode.WRITE, eager=true)
    @Description(value="apoc.merge.relationship(startNode, relType,  identProps:{key:value, ...}, onCreateProps:{key:value, ...}, endNode, onMatchProps:{key:value, ...}) - merge relationship with dynamic type, with support for setting properties ON CREATE or ON MATCH")
    public Stream<RelationshipResult> relationshipEager(@Name(value="startNode") Node startNode, @Name(value="relationshipType") String relType, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props") Map<String, Object> onCreateProps, @Name(value="endNode") Node endNode, @Name(value="onMatchProps", defaultValue="{}") Map<String, Object> onMatchProps) {
        return this.relationship(startNode, relType, identProps, onCreateProps, endNode, onMatchProps);
    }

    private String buildIdentPropsString(Map<String, Object> identProps) {
        if (identProps == null) {
            return "";
        }
        return identProps.keySet().stream().map(Util::quote).map(s -> s + ":$identProps." + s).collect(Collectors.joining(","));
    }
}

