/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class MetaConfig {
    private final Set<String> includesLabels;
    private final Set<String> includesRels;
    private final Set<String> excludes;
    private final Set<String> excludeRels;
    private final long maxRels;
    private final long sample;
    private final boolean addRelationshipsBetweenNodes;

    public MetaConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        HashSet<String> includesLabelsLocal = new HashSet<String>((Collection)config.getOrDefault("labels", Collections.EMPTY_SET));
        HashSet<String> includesRelsLocal = new HashSet<String>((Collection)config.getOrDefault("rels", Collections.EMPTY_SET));
        HashSet<String> excludesLocal = new HashSet<String>((Collection)config.getOrDefault("excludes", Collections.EMPTY_SET));
        if (includesLabelsLocal.isEmpty()) {
            includesLabelsLocal = new HashSet((Collection)config.getOrDefault("includeLabels", Collections.EMPTY_SET));
        }
        if (includesRelsLocal.isEmpty()) {
            includesRelsLocal = new HashSet((Collection)config.getOrDefault("includeRels", Collections.EMPTY_SET));
        }
        if (excludesLocal.isEmpty()) {
            excludesLocal = new HashSet((Collection)config.getOrDefault("excludeLabels", Collections.EMPTY_SET));
        }
        this.includesLabels = includesLabelsLocal;
        this.includesRels = includesRelsLocal;
        this.excludes = excludesLocal;
        this.excludeRels = new HashSet<String>((Collection)config.getOrDefault("excludeRels", Collections.EMPTY_SET));
        this.sample = (Long)config.getOrDefault("sample", 1000L);
        this.maxRels = (Long)config.getOrDefault("maxRels", 100L);
        this.addRelationshipsBetweenNodes = Util.toBoolean(config.getOrDefault("addRelationshipsBetweenNodes", true));
    }

    public Set<String> getIncludesLabels() {
        return this.includesLabels;
    }

    public Set<String> getIncludesRels() {
        return this.includesRels;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Set<String> getExcludeRels() {
        return this.excludeRels;
    }

    public long getSample() {
        return this.sample;
    }

    public long getMaxRels() {
        return this.maxRels;
    }

    public boolean matches(Label l) {
        if (this.getExcludes().contains(l.name())) {
            return false;
        }
        if (this.getIncludesLabels().isEmpty()) {
            return true;
        }
        return this.getIncludesLabels().contains(l.name());
    }

    public boolean matches(Iterable<Label> labels2) {
        boolean match = true;
        for (Label l : labels2) {
            match = match || this.matches(l);
        }
        return match;
    }

    public boolean matches(Relationship r) {
        return this.matches(r.getType());
    }

    public boolean matches(RelationshipType rt) {
        String name = rt.name();
        if (this.getExcludeRels().contains(name)) {
            return false;
        }
        if (this.getIncludesRels().isEmpty()) {
            return true;
        }
        return this.getIncludesRels().contains(name);
    }

    public boolean isAddRelationshipsBetweenNodes() {
        return this.addRelationshipsBetweenNodes;
    }
}

