/*
 * Decompiled with CFR 0.152.
 */
package apoc.model;

import apoc.Extended;
import apoc.load.util.JdbcUtil;
import apoc.load.util.LoadJdbcConfig;
import apoc.model.ModelConfig;
import apoc.result.VirtualNode;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.utility.SchemaCrawlerUtility;

@Extended
public class Model {
    @Context
    public Transaction tx;

    private Node createNode(String label, String name, boolean virtual) {
        if (virtual) {
            return new VirtualNode(new Label[]{Label.label((String)label)}, Util.map("name", name));
        }
        Node node = this.tx.createNode();
        node.addLabel(Label.label((String)label));
        node.setProperty("name", (Object)name);
        return node;
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.model.jdbc('key or url', {schema:'<schema>', write: <true/false>, filters: { tables:[], views: [], columns: []}) YIELD nodes, relationships - load schema from relational database")
    public Stream<DatabaseModel> jdbc(@Name(value="jdbc") String urlOrKey, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        String url = JdbcUtil.getUrlOrKey(urlOrKey);
        SchemaCrawlerOptionsBuilder optionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
        SchemaCrawlerOptions options = optionsBuilder.toOptions();
        Catalog catalog = SchemaCrawlerUtility.getCatalog(JdbcUtil.getConnection(url, new LoadJdbcConfig(config)), options);
        DatabaseModel databaseModel = new DatabaseModel();
        ModelConfig modelConfig = new ModelConfig(config != null ? config : Collections.emptyMap());
        boolean virtual = !modelConfig.isWrite();
        for (Schema schema : catalog.getSchemas()) {
            if (!modelConfig.getSchema().equalsIgnoreCase(schema.getFullName())) continue;
            Node schemaNode = databaseModel.add(this.createNode("Schema", schema.getFullName(), virtual));
            for (Table table : catalog.getTables(schema)) {
                boolean matchTableView;
                boolean isView = table instanceof View;
                List<String> patterns = isView ? modelConfig.getViews() : modelConfig.getTables();
                boolean bl = matchTableView = patterns.isEmpty() ? true : patterns.stream().anyMatch(p -> table.getName().matches((String)p));
                if (!matchTableView) continue;
                Node tableNode = databaseModel.add(this.createNode("Table", table.getName(), virtual));
                databaseModel.add(tableNode.createRelationshipTo(schemaNode, RelationshipType.withName((String)"IN_SCHEMA")));
                if (isView) {
                    tableNode.addLabel(Label.label((String)"View"));
                }
                for (Column column : table.getColumns()) {
                    boolean matchColumn;
                    boolean bl2 = matchColumn = modelConfig.getColumns().isEmpty() ? true : modelConfig.getColumns().stream().anyMatch(p -> column.getName().matches((String)p));
                    if (!matchColumn) continue;
                    Node columnNode = databaseModel.add(this.createNode("Column", column.getName(), virtual));
                    columnNode.setProperty("type", (Object)column.getColumnDataType().getDatabaseSpecificTypeName());
                    databaseModel.add(columnNode.createRelationshipTo(tableNode, RelationshipType.withName((String)"IN_TABLE")));
                    if (column.isPartOfPrimaryKey()) {
                        columnNode.addLabel(Label.label((String)"PrimaryKey"));
                    }
                    if (column.isPartOfForeignKey()) {
                        columnNode.addLabel(Label.label((String)"ForeignKey"));
                    }
                    if (!column.isPartOfUniqueIndex()) continue;
                    columnNode.setProperty("unique", (Object)true);
                }
            }
        }
        return Stream.of(databaseModel);
    }

    public static class DatabaseModel {
        public final List<Node> nodes = new ArrayList<Node>();
        public final List<Relationship> relationships = new ArrayList<Relationship>();

        public Node add(Node node) {
            this.nodes.add(node);
            return node;
        }

        public Relationship add(Relationship relationship) {
            this.relationships.add(relationship);
            return relationship;
        }
    }
}

