/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.Extended;
import apoc.mongodb.MongoDBColl;
import apoc.mongodb.MongoDbConfig;
import apoc.result.LongResult;
import apoc.result.MapResult;
import apoc.util.MissingDependencyException;
import apoc.util.UrlResolver;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class MongoDB {
    @Context
    public Log log;

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.get(host-or-key,db,collection,query,[compatibleValues=false|true],skip-or-null,limit-or-null,[extractReferences=false|true],[objectIdAsMap=true|false]) yield value - perform a find operation on mongodb collection")
    public Stream<MapResult> get(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="compatibleValues", defaultValue="false") boolean compatibleValues, @Name(value="skip", defaultValue="0") Long skip, @Name(value="limit", defaultValue="0") Long limit, @Name(value="extractReferences", defaultValue="false") boolean extractReferences, @Name(value="objectIdAsMap", defaultValue="true") boolean objectIdAsMap) {
        return this.executeMongoQuery(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap, coll -> coll.all(query, skip, limit).map(MapResult::new), e -> this.log.error("apoc.mongodb.get - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "], compatibleValues = [" + compatibleValues + "], skip = [" + skip + "], limit = [" + limit + "]", (Throwable)e));
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.count(host-or-key,db,collection,query) yield value - perform a find operation on mongodb collection")
    public Stream<LongResult> count(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query) {
        return this.executeMongoQuery(hostOrKey, db, collection, false, false, false, coll -> {
            long count = coll.count(query);
            return Stream.of(new LongResult(count));
        }, e -> this.log.error("apoc.mongodb.count - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "]", (Throwable)e));
    }

    private Coll getColl(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        String url = this.getMongoDBUrl(hostOrKey);
        return Coll.Factory.create(url, db, collection, compatibleValues, extractReferences, objectIdAsMap);
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.first(host-or-key,db,collection,query,[compatibleValues=false|true],[extractReferences=false|true],[objectIdAsMap=true|false]) yield value - perform a first operation on mongodb collection")
    public Stream<MapResult> first(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="compatibleValues", defaultValue="true") boolean compatibleValues, @Name(value="extractReferences", defaultValue="false") boolean extractReferences, @Name(value="objectIdAsMap", defaultValue="true") boolean objectIdAsMap) {
        return this.executeMongoQuery(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap, coll -> {
            Map<String, Object> result = coll.first(query);
            return result == null || result.isEmpty() ? Stream.empty() : Stream.of(new MapResult(result));
        }, e -> this.log.error("apoc.mongodb.first - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "], compatibleValues = [" + compatibleValues + "]", (Throwable)e));
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.find(host-or-key,db,collection,query,projection,sort,[compatibleValues=false|true],skip-or-null,limit-or-null,[extractReferences=false|true],[objectIdAsMap=true|false]) yield value - perform a find,project,sort operation on mongodb collection")
    public Stream<MapResult> find(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="project") Map<String, Object> project, @Name(value="sort") Map<String, Object> sort, @Name(value="compatibleValues", defaultValue="false") boolean compatibleValues, @Name(value="skip", defaultValue="0") Long skip, @Name(value="limit", defaultValue="0") Long limit, @Name(value="extractReferences", defaultValue="false") boolean extractReferences, @Name(value="objectIdAsMap", defaultValue="true") boolean objectIdAsMap) {
        return this.executeMongoQuery(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap, coll -> coll.find(query, project, sort, skip, limit).map(MapResult::new), e -> this.log.error("apoc.mongodb.find - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "], project = [" + project + "], sort = [" + sort + "], compatibleValues = [" + compatibleValues + "], skip = [" + skip + "], limit = [" + limit + "]", (Throwable)e));
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.insert(host-or-key,db,collection,documents) - inserts the given documents into the mongodb collection")
    public void insert(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="documents") List<Map<String, Object>> documents) {
        try (Coll coll = this.getMongoColl(hostOrKey, db, collection, false, false, false);){
            coll.insert(documents);
        }
        catch (Exception e) {
            this.log.error("apoc.mongodb.insert - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], documents = [" + documents + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.delete(host-or-key,db,collection,query) - delete the given documents from the mongodb collection and returns the number of affected documents")
    public Stream<LongResult> delete(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query) {
        return this.executeMongoQuery(hostOrKey, db, collection, false, false, false, coll -> Stream.of(new LongResult(coll.delete(query))), e -> this.log.error("apoc.mongodb.delete - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "]", (Throwable)e));
    }

    @Deprecated
    @Procedure
    @Description(value="apoc.mongodb.update(host-or-key,db,collection,query,update) - updates the given documents from the mongodb collection and returns the number of affected documents")
    public Stream<LongResult> update(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="query") Map<String, Object> query, @Name(value="update") Map<String, Object> update) {
        return this.executeMongoQuery(hostOrKey, db, collection, false, false, false, coll -> Stream.of(new LongResult(coll.update(query, update))), e -> this.log.error("apoc.mongodb.update - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], query = [" + query + "], update = [" + update + "]", (Throwable)e));
    }

    @Procedure(value="apoc.mongodb.get.byObjectId")
    @Description(value="apoc.mongodb.get.byObjectId(hostOrKey, db, collection, objectIdValue, config(default:{})) - get the document by Object id value")
    public Stream<MapResult> byObjectId(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="objectIdValue") String objectIdValue, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = new MongoDbConfig(config);
        return this.executeMongoQuery(hostOrKey, db, collection, conf.isCompatibleValues(), conf.isExtractReferences(), conf.isObjectIdAsMap(), coll -> {
            Map<String, Object> result = coll.first(Map.of(conf.getIdFieldName(), new ObjectId(objectIdValue)));
            return result == null || result.isEmpty() ? Stream.empty() : Stream.of(new MapResult(result));
        }, e -> this.log.error("apoc.mongo.get.byObjectId - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], objectIdValue = [" + objectIdValue + "]", (Throwable)e));
    }

    private String getMongoDBUrl(String hostOrKey) {
        return new UrlResolver("mongodb", "localhost", 27017).getUrl("mongodb", hostOrKey);
    }

    private Coll getMongoColl(String hostOrKey, String db, String collection, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        Coll coll = null;
        try {
            coll = this.getColl(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap);
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException("Cannot find the jar into the plugins folder. \nPlease put these jar in the plugins folder :\n\nbson-x.y.z.jar\n\nmongo-java-driver-x.y.z.jar\n\nmongodb-driver-x.y.z.jar\n\nmongodb-driver-core-x.y.z.jar\n\njackson-annotations-x.y.z.jar\n\njackson-core-x.y.z.jar\n\njackson-databind-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_interacting_with_mongodb");
        }
        return coll;
    }

    private <T> Stream<T> executeMongoQuery(String hostOrKey, String db, String collection, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap, Function<Coll, Stream<T>> execute, Consumer<Exception> onError) {
        Coll coll = null;
        try {
            coll = this.getMongoColl(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap);
            return (Stream)execute.apply(coll).onClose(coll::safeClose);
        }
        catch (Exception e) {
            if (coll != null) {
                coll.safeClose();
            }
            onError.accept(e);
            throw new RuntimeException(e);
        }
    }

    static interface Coll
    extends Closeable {
        public Map<String, Object> first(Map<String, Object> var1);

        public Stream<Map<String, Object>> all(Map<String, Object> var1, Long var2, Long var3);

        public long count(Map<String, Object> var1);

        public Stream<Map<String, Object>> find(Map<String, Object> var1, Map<String, Object> var2, Map<String, Object> var3, Long var4, Long var5);

        public void insert(List<Map<String, Object>> var1);

        public long update(Map<String, Object> var1, Map<String, Object> var2);

        public long delete(Map<String, Object> var1);

        default public void safeClose() {
            try {
                this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static class Factory {
            public static Coll create(String url, String db, String coll, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
                try {
                    return new MongoDBColl(url, db, coll, compatibleValues, extractReferences, objectIdAsMap);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create MongoDBClientWrapper instance", e);
                }
            }
        }
    }
}

