/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class MongoDbConfig {
    private final boolean compatibleValues;
    private final boolean extractReferences;
    private final boolean objectIdAsMap;
    private final String idFieldName;

    public MongoDbConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.compatibleValues = Util.toBoolean(config.getOrDefault("compatibleValues", true));
        this.extractReferences = Util.toBoolean(config.getOrDefault("extractReferences", false));
        this.objectIdAsMap = Util.toBoolean(config.getOrDefault("objectIdAsMap", true));
        this.idFieldName = (String)config.getOrDefault("idFieldName", "_id");
    }

    public boolean isCompatibleValues() {
        return this.compatibleValues;
    }

    public boolean isExtractReferences() {
        return this.extractReferences;
    }

    public boolean isObjectIdAsMap() {
        return this.objectIdAsMap;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }
}

