/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.neo4j.graphdb.Node;

public class LabelMatcher {
    private List<String> labels = new ArrayList<String>();
    private List<List<String>> compoundLabels;
    private static LabelMatcher ACCEPTS_ALL_LABEL_MATCHER = new LabelMatcher(){

        @Override
        public boolean matchesLabels(Node node) {
            return true;
        }

        @Override
        public LabelMatcher addLabel(String label) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    };

    public static LabelMatcher acceptsAllLabelMatcher() {
        return ACCEPTS_ALL_LABEL_MATCHER;
    }

    public LabelMatcher addLabel(String label) {
        String[] elements;
        if ("*".equals(label)) {
            return ACCEPTS_ALL_LABEL_MATCHER;
        }
        if (label.charAt(0) == ':') {
            label = label.substring(1);
        }
        if ((elements = label.split(":")).length == 1) {
            this.labels.add(label);
        } else if (elements.length > 1) {
            if (this.compoundLabels == null) {
                this.compoundLabels = new ArrayList<List<String>>();
            }
            this.compoundLabels.add(Arrays.asList(elements));
        }
        return this;
    }

    public boolean matchesLabels(Node node) {
        HashSet nodeLabels = new HashSet();
        node.getLabels().forEach(label -> nodeLabels.add(label.name()));
        for (String string : this.labels) {
            if (!nodeLabels.contains(string)) continue;
            return true;
        }
        if (this.compoundLabels != null) {
            for (List list : this.compoundLabels) {
                if (!nodeLabels.containsAll(list)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty() && (this.compoundLabels == null || this.compoundLabels.isEmpty());
    }
}

