/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.periodic.BatchAndTotalResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.procedure.TerminationGuard;

public class BatchAndTotalCollector {
    private final int failedParams;
    private long start = System.nanoTime();
    private AtomicLong batches = new AtomicLong();
    private long successes = 0L;
    private AtomicLong count = new AtomicLong();
    private AtomicLong failedOps = new AtomicLong();
    private AtomicLong retried = new AtomicLong();
    private Map<String, Long> operationErrors = new ConcurrentHashMap<String, Long>();
    private AtomicInteger failedBatches = new AtomicInteger();
    private Map<String, Long> batchErrors = new HashMap<String, Long>();
    private Map<String, List<Map<String, Object>>> failedParamsMap = new ConcurrentHashMap<String, List<Map<String, Object>>>();
    private final boolean wasTerminated;
    private AtomicLong nodesCreated = new AtomicLong();
    private AtomicLong nodesDeleted = new AtomicLong();
    private AtomicLong relationshipsCreated = new AtomicLong();
    private AtomicLong relationshipsDeleted = new AtomicLong();
    private AtomicLong propertiesSet = new AtomicLong();
    private AtomicLong labelsAdded = new AtomicLong();
    private AtomicLong labelsRemoved = new AtomicLong();

    public BatchAndTotalCollector(TerminationGuard terminationGuard, int failedParams) {
        this.failedParams = failedParams;
        this.wasTerminated = Util.transactionIsTerminated(terminationGuard);
    }

    public BatchAndTotalResult getResult() {
        long timeTaken = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start);
        HashMap<String, Long> updateStatistics = new HashMap<String, Long>();
        updateStatistics.put("nodesCreated", this.nodesCreated.get());
        updateStatistics.put("nodesDeleted", this.nodesDeleted.get());
        updateStatistics.put("relationshipsCreated", this.relationshipsCreated.get());
        updateStatistics.put("relationshipsDeleted", this.relationshipsDeleted.get());
        updateStatistics.put("propertiesSet", this.propertiesSet.get());
        updateStatistics.put("labelsAdded", this.labelsAdded.get());
        updateStatistics.put("labelsRemoved", this.labelsRemoved.get());
        return new BatchAndTotalResult(this.batches.get(), this.count.get(), timeTaken, this.successes, this.failedOps.get(), this.failedBatches.get(), this.retried.get(), this.operationErrors, this.batchErrors, this.wasTerminated, this.failedParamsMap, updateStatistics);
    }

    public long getBatches() {
        return this.batches.get();
    }

    public long getCount() {
        return this.count.get();
    }

    public void incrementFailedOps(long size) {
        this.failedOps.addAndGet(size);
    }

    public void incrementBatches() {
        this.batches.incrementAndGet();
    }

    public void incrementSuccesses(long increment) {
        this.successes += increment;
    }

    public void incrementCount(long currentBatchSize) {
        this.count.addAndGet(currentBatchSize);
    }

    public Map<String, Long> getBatchErrors() {
        return this.batchErrors;
    }

    public Map<String, Long> getOperationErrors() {
        return this.operationErrors;
    }

    public Map<String, List<Map<String, Object>>> getFailedParamsMap() {
        return this.failedParamsMap;
    }

    public void amendFailedParamsMap(List<Map<String, Object>> batch) {
        if (this.failedParams >= 0) {
            this.failedParamsMap.put(Long.toString(this.batches.get()), new ArrayList<Map<String, Object>>(batch.subList(0, Math.min(this.failedParams + 1, batch.size()))));
        }
    }

    public AtomicInteger getFailedBatches() {
        return this.failedBatches;
    }

    public void incrementRetried() {
        this.retried.incrementAndGet();
    }

    public void updateStatistics(QueryStatistics stats) {
        this.nodesCreated.addAndGet(stats.getNodesCreated());
        this.nodesDeleted.addAndGet(stats.getNodesDeleted());
        this.relationshipsCreated.addAndGet(stats.getRelationshipsCreated());
        this.relationshipsDeleted.addAndGet(stats.getRelationshipsDeleted());
        this.propertiesSet.addAndGet(stats.getPropertiesSet());
        this.labelsAdded.addAndGet(stats.getLabelsAdded());
        this.labelsRemoved.addAndGet(stats.getLabelsRemoved());
    }
}

