/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.Pools;
import apoc.periodic.BatchAndTotalCollector;
import apoc.periodic.BatchAndTotalResult;
import apoc.periodic.BatchMode;
import apoc.periodic.Periodic;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.ToLongFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class PeriodicUtils {
    private PeriodicUtils() {
    }

    public static Pair<String, Boolean> prepareInnerStatement(String cypherAction, BatchMode batchMode, List<String> columns, String iteratorVariableName) {
        String names = columns.stream().map(Util::quote).collect(Collectors.joining("|"));
        boolean withCheck = PeriodicUtils.regNoCaseMultiLine("[{$](" + names + ")\\}?\\s+AS\\s+").matcher(cypherAction).find();
        if (withCheck) {
            return Pair.of((Object)cypherAction, (Object)false);
        }
        switch (batchMode) {
            case SINGLE: {
                return Pair.of((Object)(Util.withMapping(columns.stream(), c -> Util.param(c) + " AS " + Util.quote(c)) + cypherAction), (Object)false);
            }
            case BATCH: {
                if (PeriodicUtils.regNoCaseMultiLine("UNWIND\\s+[{$]" + iteratorVariableName + "\\}?\\s+AS\\s+").matcher(cypherAction).find()) {
                    return Pair.of((Object)cypherAction, (Object)true);
                }
                String with = Util.withMapping(columns.stream(), c -> Util.quote(iteratorVariableName) + "." + Util.quote(c) + " AS " + Util.quote(c));
                return Pair.of((Object)("UNWIND " + Util.param(iteratorVariableName) + " AS " + Util.quote(iteratorVariableName) + with + " " + cypherAction), (Object)true);
            }
            case BATCH_SINGLE: {
                return Pair.of((Object)cypherAction, (Object)true);
            }
        }
        throw new IllegalArgumentException("Unrecognised batch mode: [" + batchMode + "]");
    }

    public static Pattern regNoCaseMultiLine(String pattern) {
        return Pattern.compile(pattern, 42);
    }

    public static Stream<BatchAndTotalResult> iterateAndExecuteBatchedInSeparateThread(GraphDatabaseService db, TerminationGuard terminationGuard, Log log, Pools pools, int batchsize, boolean parallel, boolean iterateList, long retries, Iterator<Map<String, Object>> iterator, BiFunction<Transaction, Map<String, Object>, QueryStatistics> consumer, int concurrency, int failedParams) {
        boolean wasTerminated;
        ExecutorService pool = parallel ? pools.getDefaultExecutorService() : pools.getSingleExecutorService();
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(concurrency);
        BatchAndTotalCollector collector = new BatchAndTotalCollector(terminationGuard, failedParams);
        AtomicInteger activeFutures = new AtomicInteger(0);
        while (!Util.transactionIsTerminated(terminationGuard)) {
            if (activeFutures.get() < concurrency || !parallel) {
                activeFutures.incrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug("execute in batch no %d batch size ", new Object[]{batchsize});
                }
                List<Map<String, Object>> batch = Util.take(iterator, batchsize);
                long currentBatchSize = batch.size();
                Periodic.ExecuteBatch executeBatch = iterateList ? new Periodic.ListExecuteBatch(terminationGuard, collector, batch, consumer) : new Periodic.OneByOneExecuteBatch(terminationGuard, collector, batch, consumer);
                futures.add(Util.inTxFuture(log, pool, db, executeBatch, retries, retryCount -> collector.incrementRetried(), onComplete -> {
                    collector.incrementBatches();
                    executeBatch.release();
                    activeFutures.decrementAndGet();
                }));
                collector.incrementCount(currentBatchSize);
            } else {
                LockSupport.parkNanos(1000L);
            }
            if (iterator.hasNext()) continue;
        }
        ToLongFunction<Future> toLongFunction = (wasTerminated = Util.transactionIsTerminated(terminationGuard)) ? f -> Util.getFutureOrCancel(f, collector.getBatchErrors(), collector.getFailedBatches(), 0L) : f -> Util.getFuture(f, collector.getBatchErrors(), collector.getFailedBatches(), 0L);
        collector.incrementSuccesses(futures.stream().mapToLong(toLongFunction).sum());
        Util.logErrors("Error during iterate.commit:", collector.getBatchErrors(), log);
        Util.logErrors("Error during iterate.execute:", collector.getOperationErrors(), log);
        return Stream.of(collector.getResult());
    }
}

