/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor.util;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class RefactorConfig {
    public static final String COMBINE = "combine";
    public static final String DISCARD = "discard";
    public static final String OVERWRITE = "overwrite";
    public static final String OVERRIDE = "override";
    private static String MATCH_ALL = ".*";
    private Map<String, String> propertiesManagement = Collections.singletonMap(MATCH_ALL, "overwrite");
    private boolean mergeRelsAllowed;
    private boolean mergeVirtualRels;
    private boolean selfRel;
    private boolean createNewSelfRel;
    private boolean preserveExistingSelfRels;
    private boolean countMerge;
    private boolean hasProperties;
    private boolean collapsedLabel;
    private boolean singleElementAsArray;
    private final RelationshipSelectionStrategy relationshipSelectionStrategy;

    public RefactorConfig(Map<String, Object> config) {
        this.mergeRelsAllowed = Util.toBoolean(config.get("mergeRels"));
        this.mergeVirtualRels = Util.toBoolean(config.getOrDefault("mergeRelsVirtual", true));
        this.selfRel = Util.toBoolean(config.get("selfRel"));
        this.createNewSelfRel = Util.toBoolean(config.getOrDefault("produceSelfRel", true));
        this.preserveExistingSelfRels = Util.toBoolean(config.getOrDefault("preserveExistingSelfRels", true));
        this.countMerge = Util.toBoolean(config.getOrDefault("countMerge", true));
        this.collapsedLabel = Util.toBoolean(config.get("collapsedLabel"));
        this.singleElementAsArray = Util.toBoolean(config.getOrDefault("singleElementAsArray", false));
        this.relationshipSelectionStrategy = RelationshipSelectionStrategy.valueOf(((String)config.getOrDefault("relationshipSelectionStrategy", RelationshipSelectionStrategy.INCOMING.toString())).toUpperCase());
        Object value = config.get("properties");
        boolean bl = this.hasProperties = value != null;
        if (value instanceof String) {
            this.propertiesManagement = Collections.singletonMap(MATCH_ALL, value.toString());
        } else if (value instanceof Map) {
            this.propertiesManagement = (Map)value;
        } else if (this.mergeRelsAllowed && !this.hasProperties) {
            this.propertiesManagement = Collections.singletonMap(MATCH_ALL, COMBINE);
        }
    }

    public String getMergeMode(String name) {
        for (String key : this.propertiesManagement.keySet()) {
            if (key.equals(MATCH_ALL) || !name.matches(key)) continue;
            return this.propertiesManagement.get(key);
        }
        return this.propertiesManagement.getOrDefault(name, this.propertiesManagement.getOrDefault(MATCH_ALL, OVERWRITE));
    }

    public String getMergeModeVirtual(String name) {
        for (String key : this.propertiesManagement.keySet()) {
            if (key.equals(MATCH_ALL) || !name.matches(key)) continue;
            return this.propertiesManagement.get(key);
        }
        return this.propertiesManagement.getOrDefault(name, this.propertiesManagement.getOrDefault(MATCH_ALL, DISCARD));
    }

    public boolean getMergeRelsAllowed() {
        return this.mergeRelsAllowed;
    }

    public boolean isSelfRel() {
        return this.selfRel;
    }

    public boolean isCreatingNewSelfRel() {
        return this.createNewSelfRel;
    }

    public boolean isPreservingExistingSelfRels() {
        return this.preserveExistingSelfRels;
    }

    public boolean hasProperties() {
        return this.hasProperties;
    }

    public boolean isCountMerge() {
        return this.countMerge;
    }

    public boolean isCollapsedLabel() {
        return this.collapsedLabel;
    }

    public boolean isMergeVirtualRels() {
        return this.mergeVirtualRels;
    }

    public boolean isSingleElementAsArray() {
        return this.singleElementAsArray;
    }

    public RelationshipSelectionStrategy getRelationshipSelectionStrategy() {
        return this.relationshipSelectionStrategy;
    }

    public static enum RelationshipSelectionStrategy {
        INCOMING,
        OUTGOING,
        MERGE;

    }
}

