/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import apoc.result.AssertSchemaResult;
import apoc.result.ConstraintRelationshipInfo;
import apoc.result.IndexConstraintNodeInfo;
import apoc.schema.SchemaConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Schemas {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;

    @Procedure(value="apoc.schema.assert", mode=Mode.SCHEMA)
    @Description(value="apoc.schema.assert({indexLabel:[[indexKeys]], ...}, {constraintLabel:[constraintKeys], ...}, dropExisting : true) yield label, key, keys, unique, action - drops all other existing indexes and constraints when `dropExisting` is `true` (default is `true`), and asserts that at the end of the operation the given indexes and unique constraints are there, each label:key pair is considered one constraint/label. Non-constraint indexes can define compound indexes with label:[key1,key2...] pairings.")
    public Stream<AssertSchemaResult> schemaAssert(@Name(value="indexes") Map<String, List<Object>> indexes, @Name(value="constraints") Map<String, List<Object>> constraints, @Name(value="dropExisting", defaultValue="true") boolean dropExisting) throws ExecutionException, InterruptedException {
        return Stream.concat(this.assertIndexes(indexes, dropExisting).stream(), this.assertConstraints(constraints, dropExisting).stream());
    }

    @Procedure(value="apoc.schema.nodes", mode=Mode.SCHEMA)
    @Description(value="CALL apoc.schema.nodes([config]) yield name, label, properties, status, type")
    public Stream<IndexConstraintNodeInfo> nodes(@Name(value="config", defaultValue="{}") Map<String, Object> config) throws IndexNotFoundKernelException {
        return this.indexesAndConstraintsForNode(config);
    }

    @Procedure(value="apoc.schema.relationships", mode=Mode.SCHEMA)
    @Description(value="CALL apoc.schema.relationships([config]) yield name, startLabel, type, endLabel, properties, status")
    public Stream<ConstraintRelationshipInfo> relationships(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.constraintsForRelationship(config);
    }

    @UserFunction(value="apoc.schema.node.indexExists")
    @Description(value="RETURN apoc.schema.node.indexExists(labelName, propertyNames)")
    public Boolean indexExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.indexExists(labelName, propertyNames);
    }

    @UserFunction(value="apoc.schema.node.constraintExists")
    @Description(value="RETURN apoc.schema.node.constraintExists(labelName, propertyNames)")
    public Boolean constraintExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExists(labelName, propertyNames);
    }

    @UserFunction(value="apoc.schema.relationship.constraintExists")
    @Description(value="RETURN apoc.schema.relationship.constraintExists(type, propertyNames)")
    public Boolean constraintExistsOnRelationship(@Name(value="type") String type, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExistsForRelationship(type, propertyNames);
    }

    public List<AssertSchemaResult> assertConstraints(Map<String, List<Object>> constraints0, boolean dropExisting) throws ExecutionException, InterruptedException {
        Map<String, List<Object>> constraints = this.copyMapOfObjects(constraints0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(constraints.size());
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : schema.getConstraints()) {
            AssertSchemaResult info;
            String label = constraintDefinition.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE) ? constraintDefinition.getRelationshipType().name() : constraintDefinition.getLabel().name();
            if (!this.checkIfConstraintExists(label, constraints, info = new AssertSchemaResult(label, Iterables.asList((Iterable)constraintDefinition.getPropertyKeys())).unique()) && dropExisting) {
                constraintDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : constraints.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createUniqueConstraint(schema, (String)entry.getKey(), key.toString()));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createNodeKeyConstraint((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private boolean checkIfConstraintExists(String label, Map<String, List<Object>> constraints, AssertSchemaResult info) {
        if (constraints.containsKey(label)) {
            return constraints.get(label).removeIf(item -> {
                if (item instanceof String) {
                    return item.equals(info.key);
                }
                return info.keys.equals(item);
            });
        }
        return false;
    }

    private AssertSchemaResult createNodeKeyConstraint(String lbl, List<Object> keys) {
        String keyProperties = keys.stream().map(property -> String.format("n.`%s`", property)).collect(Collectors.joining(","));
        this.tx.execute(String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT (%s) IS NODE KEY", lbl, keyProperties)).close();
        List<String> keysToSting = keys.stream().map(Object::toString).collect(Collectors.toList());
        return new AssertSchemaResult(lbl, keysToSting).unique().created();
    }

    private AssertSchemaResult createUniqueConstraint(Schema schema, String lbl, String key) {
        schema.constraintFor(Label.label((String)lbl)).assertPropertyIsUnique(key).create();
        return new AssertSchemaResult(lbl, key).unique().created();
    }

    public List<AssertSchemaResult> assertIndexes(Map<String, List<Object>> indexes0, boolean dropExisting) throws ExecutionException, InterruptedException, IllegalArgumentException {
        Schema schema = this.tx.schema();
        Map<String, List<Object>> indexes = this.copyMapOfObjects(indexes0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(indexes.size());
        for (IndexDefinition indexDefinition : schema.getIndexes()) {
            if (indexDefinition.isConstraintIndex()) continue;
            String label = ((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name();
            ArrayList<String> keys = new ArrayList<String>();
            indexDefinition.getPropertyKeys().forEach(keys::add);
            AssertSchemaResult info = new AssertSchemaResult(label, keys);
            if (indexes.containsKey(label)) {
                if (keys.size() > 1) {
                    indexes.get(label).remove(keys);
                } else if (keys.size() == 1) {
                    indexes.get(label).remove(keys.get(0));
                } else {
                    throw new IllegalArgumentException("Label given with no keys.");
                }
            }
            if (dropExisting) {
                indexDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        if (dropExisting) {
            indexes = this.copyMapOfObjects(indexes0);
        }
        for (Map.Entry entry : indexes.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createSinglePropertyIndex(schema, (String)entry.getKey(), (String)key));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createCompoundIndex((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private AssertSchemaResult createSinglePropertyIndex(Schema schema, String lbl, String key) {
        schema.indexFor(Label.label((String)lbl)).on(key).create();
        return new AssertSchemaResult(lbl, key).created();
    }

    private AssertSchemaResult createCompoundIndex(String label, List<String> keys) {
        ArrayList backTickedKeys = new ArrayList();
        keys.forEach(key -> backTickedKeys.add(String.format("`%s`", key)));
        this.tx.execute(String.format("CREATE INDEX ON :`%s` (%s)", label, String.join((CharSequence)",", backTickedKeys)));
        return new AssertSchemaResult(label, keys).created();
    }

    private Map<String, List<Object>> copyMapOfObjects(Map<String, List<Object>> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(input.size());
        input.forEach((k, v) -> result.put((String)k, new ArrayList(v)));
        return result;
    }

    private Boolean indexExists(String labelName, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (IndexDefinition indexDefinition : Iterables.asList((Iterable)schema.getIndexes(Label.label((String)labelName)))) {
            List properties = Iterables.asList((Iterable)indexDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExists(String labelName, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList((Iterable)schema.getConstraints(Label.label((String)labelName)))) {
            List properties = Iterables.asList((Iterable)constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExistsForRelationship(String type, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList((Iterable)schema.getConstraints(RelationshipType.withName((String)type)))) {
            List properties = Iterables.asList((Iterable)constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Stream<IndexConstraintNodeInfo> indexesAndConstraintsForNode(Map<String, Object> config) {
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeLabels = schemaConfig.getLabels();
        Set<String> excludeLabels = schemaConfig.getExcludeLabels();
        try (Statement ignore = this.ktx.acquireStatement();){
            Iterable constraintsIterator;
            Iterable indexesIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            SchemaRead schemaRead = this.ktx.schemaRead();
            if (includeLabels.isEmpty()) {
                Iterator allIndex = schemaRead.indexesGetAll();
                indexesIterator = StreamSupport.stream(Spliterators.spliteratorUnknownSize(allIndex, 16), false).filter(index -> Arrays.stream(index.schema().getEntityTokenIds()).noneMatch(id -> {
                    try {
                        return excludeLabels.contains(tokenRead.nodeLabelName(id));
                    }
                    catch (LabelNotFoundKernelException e) {
                        return false;
                    }
                })).collect(Collectors.toList());
                Iterable allConstraints = () -> schemaRead.constraintsGetAll();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(constraint -> Arrays.stream(constraint.schema().getEntityTokenIds()).noneMatch(id -> {
                    try {
                        return excludeLabels.contains(tokenRead.nodeLabelName(id));
                    }
                    catch (LabelNotFoundKernelException e) {
                        return false;
                    }
                })).collect(Collectors.toList());
            } else {
                constraintsIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable indexesForLabel = () -> schemaRead.constraintsGetForLabel(tokenRead.nodeLabel(label));
                    return StreamSupport.stream(indexesForLabel.spliterator(), false);
                }).collect(Collectors.toList());
                indexesIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable indexesForLabel = () -> schemaRead.indexesGetForLabel(tokenRead.nodeLabel(label));
                    return StreamSupport.stream(indexesForLabel.spliterator(), false);
                }).collect(Collectors.toList());
            }
            Stream<IndexConstraintNodeInfo> constraintNodeInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).filter(constraintDescriptor -> constraintDescriptor.type().equals((Object)org.neo4j.internal.schema.ConstraintType.EXISTS)).map(constraintDescriptor -> this.nodeInfoFromConstraintDescriptor((ConstraintDescriptor)constraintDescriptor, (TokenNameLookup)tokenRead)).sorted(Comparator.comparing(i -> i.label));
            Stream<IndexConstraintNodeInfo> indexNodeInfoStream = StreamSupport.stream(indexesIterator.spliterator(), false).map(indexDescriptor -> this.nodeInfoFromIndexDefinition((IndexDescriptor)indexDescriptor, schemaRead, (TokenNameLookup)tokenRead)).sorted(Comparator.comparing(i -> i.label));
            Stream<IndexConstraintNodeInfo> stream = Stream.of(constraintNodeInfoStream, indexNodeInfoStream).flatMap(e -> e);
            return stream;
        }
    }

    private Stream<ConstraintRelationshipInfo> constraintsForRelationship(Map<String, Object> config) {
        Schema schema = this.tx.schema();
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeRelationships = schemaConfig.getRelationships();
        Set<String> excludeRelationships = schemaConfig.getExcludeRelationships();
        try (Statement ignore = this.ktx.acquireStatement();){
            Stream<ConstraintRelationshipInfo> constraintRelationshipInfoStream;
            Iterable constraintsIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            if (!includeRelationships.isEmpty()) {
                constraintsIterator = includeRelationships.stream().filter(type -> !excludeRelationships.contains(type) && tokenRead.relationshipType(type) != -1).flatMap(type -> {
                    Iterable constraintsForType = schema.getConstraints(RelationshipType.withName((String)type));
                    return StreamSupport.stream(constraintsForType.spliterator(), false);
                }).collect(Collectors.toList());
            } else {
                Iterable allConstraints = schema.getConstraints();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(index -> !excludeRelationships.contains(index.getRelationshipType().name())).collect(Collectors.toList());
            }
            Stream<ConstraintRelationshipInfo> stream = constraintRelationshipInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).filter(constraintDefinition -> constraintDefinition.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)).map(this::relationshipInfoFromConstraintDefinition);
            return stream;
        }
    }

    private IndexConstraintNodeInfo nodeInfoFromConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TokenNameLookup tokens) {
        String labelName = tokens.labelGetName(constraintDescriptor.schema().getLabelId());
        ArrayList<String> properties = new ArrayList<String>();
        Arrays.stream(constraintDescriptor.schema().getPropertyIds()).forEach(i -> properties.add(tokens.propertyKeyGetName(i)));
        return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, ",")), labelName, properties, "", ConstraintType.NODE_PROPERTY_EXISTENCE.toString(), "NO FAILURE", 0.0f, 0L, 0.0, constraintDescriptor.userDescription(tokens));
    }

    private IndexConstraintNodeInfo nodeInfoFromIndexDefinition(IndexDescriptor indexDescriptor, SchemaRead schemaRead, TokenNameLookup tokens) {
        int[] labelIds = indexDescriptor.schema().getEntityTokenIds();
        if (labelIds.length != 1) {
            throw new IllegalStateException("Index with more than one label");
        }
        String labelName = tokens.labelGetName(labelIds[0]);
        ArrayList<String> properties = new ArrayList<String>();
        Arrays.stream(indexDescriptor.schema().getPropertyIds()).forEach(i -> properties.add(tokens.propertyKeyGetName(i)));
        try {
            return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, ",")), labelName, properties, schemaRead.indexGetState(indexDescriptor).toString(), !indexDescriptor.isUnique() ? "INDEX" : "UNIQUENESS", schemaRead.indexGetState(indexDescriptor).equals((Object)InternalIndexState.FAILED) ? schemaRead.indexGetFailure(indexDescriptor) : "NO FAILURE", schemaRead.indexGetPopulationProgress(indexDescriptor).getCompleted() / schemaRead.indexGetPopulationProgress(indexDescriptor).getTotal() * 100L, schemaRead.indexSize(indexDescriptor), schemaRead.indexUniqueValuesSelectivity(indexDescriptor), indexDescriptor.userDescription(tokens));
        }
        catch (IndexNotFoundKernelException e) {
            return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, ",")), labelName, properties, "NOT_FOUND", !indexDescriptor.isUnique() ? "INDEX" : "UNIQUENESS", "NOT_FOUND", 0.0f, 0L, 0.0, indexDescriptor.userDescription(tokens));
        }
    }

    private ConstraintRelationshipInfo relationshipInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition) {
        return new ConstraintRelationshipInfo(String.format("CONSTRAINT %s", constraintDefinition.toString()), constraintDefinition.getConstraintType().name(), Iterables.asList((Iterable)constraintDefinition.getPropertyKeys()), "");
    }
}

