/*
 * Decompiled with CFR 0.152.
 */
package apoc.temporal;

import apoc.date.Date;
import apoc.util.DateFormatUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.storable.DurationValue;

public class TemporalProcedures {
    @UserFunction(value="apoc.temporal.format")
    @Description(value="apoc.temporal.format(input, format) | Format a temporal value")
    public String format(@Name(value="temporal") Object input, @Name(value="format", defaultValue="yyyy-MM-dd") String format) {
        try {
            DateTimeFormatter formatter = DateFormatUtil.getOrCreate(format);
            if (input instanceof LocalDate) {
                return ((LocalDate)input).format(formatter);
            }
            if (input instanceof ZonedDateTime) {
                return ((ZonedDateTime)input).format(formatter);
            }
            if (input instanceof LocalDateTime) {
                return ((LocalDateTime)input).format(formatter);
            }
            if (input instanceof LocalTime) {
                return ((LocalTime)input).format(formatter);
            }
            if (input instanceof OffsetTime) {
                return ((OffsetTime)input).format(formatter);
            }
            if (input instanceof DurationValue) {
                return this.formatDuration(input, format);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Available formats are:\n" + String.join((CharSequence)"\n", DateFormatUtil.getTypes()) + "\nSee also: https://www.elastic.co/guide/en/elasticsearch/reference/5.5/mapping-date-format.html#built-in-date-formats and https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html");
        }
        return input.toString();
    }

    @UserFunction(value="apoc.temporal.formatDuration")
    @Description(value="apoc.temporal.formatDuration(input, format) | Format a Duration")
    public String formatDuration(@Name(value="input") Object input, @Name(value="format") String format) {
        try {
            LocalDateTime midnight = LocalDateTime.of(0, 1, 1, 0, 0, 0, 0);
            LocalDateTime newDuration = midnight.plus((TemporalAmount)((DurationValue)input));
            DateTimeFormatter formatter = DateFormatUtil.getOrCreate(format);
            return newDuration.format(formatter);
        }
        catch (Exception e) {
            throw new RuntimeException("Available formats are:\n" + String.join((CharSequence)"\n", DateFormatUtil.getTypes()) + "\nSee also: https://www.elastic.co/guide/en/elasticsearch/reference/5.5/mapping-date-format.html#built-in-date-formats and https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html");
        }
    }

    @UserFunction
    @Description(value="apoc.temporal.toZonedTemporal('2012-12-23 23:59:59','yyyy-MM-dd HH:mm:ss', 'UTC-hour-offset') parse date string using the specified format to specified timezone")
    public ZonedDateTime toZonedTemporal(@Name(value="time") String time, @Name(value="format", defaultValue="yyyy-MM-dd HH:mm:ss") String format, @Name(value="timezone", defaultValue="UTC") String timezone) {
        Long value = Date.parseOrThrow(time, Date.getFormat(format, timezone));
        return value == null ? null : Instant.ofEpochMilli(value).atZone(ZoneId.of(timezone));
    }
}

