/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.trigger.TriggerHandler;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Trigger {
    @Context
    public GraphDatabaseService db;
    @Context
    public TriggerHandler triggerHandler;

    @Procedure(mode=Mode.WRITE)
    @Description(value="add a trigger kernelTransaction under a name, in the kernelTransaction you can use {createdNodes}, {deletedNodes} etc., the selector is {phase:'before/after/rollback'} returns previous and new trigger information. Takes in an optional configuration.")
    public Stream<TriggerInfo> add(@Name(value="name") String name, @Name(value="kernelTransaction") String statement, @Name(value="selector") Map<String, Object> selector, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Util.validateQuery(this.db, statement, new QueryExecutionType.QueryType[0]);
        Map<String, Object> params = config.getOrDefault("params", Collections.emptyMap());
        Map<String, Object> removed = this.triggerHandler.add(name, statement, selector, params);
        if (removed != null) {
            return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), (Map)removed.get("params"), false, false), new TriggerInfo(name, statement, selector, params, true, false));
        }
        return Stream.of(new TriggerInfo(name, statement, selector, params, true, false));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="remove previously added trigger, returns trigger information")
    public Stream<TriggerInfo> remove(@Name(value="name") String name) {
        Map<String, Object> removed = this.triggerHandler.remove(name);
        if (removed == null) {
            return Stream.of(new TriggerInfo(name, null, null, false, false));
        }
        return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), (Map)removed.get("params"), false, false));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="removes all previously added trigger, returns trigger information")
    public Stream<TriggerInfo> removeAll() {
        Map<String, Object> removed = this.triggerHandler.removeAll();
        if (removed == null) {
            return Stream.of(new TriggerInfo(null, null, null, false, false));
        }
        return removed.entrySet().stream().map(this::toTriggerInfo);
    }

    public TriggerInfo toTriggerInfo(Map.Entry<String, Object> e) {
        String name = e.getKey();
        if (e.getValue() instanceof Map) {
            try {
                Map value = (Map)e.getValue();
                return new TriggerInfo(name, (String)value.get("statement"), (Map)value.get("selector"), (Map)value.get("params"), false, false);
            }
            catch (Exception ex) {
                return new TriggerInfo(name, ex.getMessage(), null, false, false);
            }
        }
        return new TriggerInfo(name, null, null, false, false);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="list all installed triggers")
    public Stream<TriggerInfo> list() {
        return this.triggerHandler.list().entrySet().stream().map(e -> new TriggerInfo((String)e.getKey(), (String)((Map)e.getValue()).get("statement"), (Map)((Map)e.getValue()).get("selector"), (Map)((Map)e.getValue()).get("params"), true, ((Map)e.getValue()).getOrDefault("paused", false)));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.trigger.pause(name) | it pauses the trigger")
    public Stream<TriggerInfo> pause(@Name(value="name") String name) {
        Map<String, Object> paused = this.triggerHandler.updatePaused(name, true);
        return Stream.of(new TriggerInfo(name, (String)paused.get("statement"), (Map)paused.get("selector"), (Map)paused.get("params"), true, true));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.trigger.resume(name) | it resumes the paused trigger")
    public Stream<TriggerInfo> resume(@Name(value="name") String name) {
        Map<String, Object> resume = this.triggerHandler.updatePaused(name, false);
        return Stream.of(new TriggerInfo(name, (String)resume.get("statement"), (Map)resume.get("selector"), (Map)resume.get("params"), true, false));
    }

    public static class TriggerInfo {
        public String name;
        public String query;
        public Map<String, Object> selector;
        public Map<String, Object> params;
        public boolean installed;
        public boolean paused;

        public TriggerInfo(String name, String query, Map<String, Object> selector, boolean installed, boolean paused) {
            this.name = name;
            this.query = query;
            this.selector = selector;
            this.installed = installed;
            this.paused = paused;
        }

        public TriggerInfo(String name, String query, Map<String, Object> selector, Map<String, Object> params, boolean installed, boolean paused) {
            this.name = name;
            this.query = query;
            this.selector = selector;
            this.params = params;
            this.installed = installed;
            this.paused = paused;
        }
    }
}

