/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.Description;
import apoc.Extended;
import apoc.coll.SetBackedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

@Extended
public class TriggerExtended {
    @Context
    public GraphDatabaseService db;

    @UserFunction
    @Description(value="function to filter labelEntries by label, to be used within a trigger kernelTransaction with {assignedLabels}, {removedLabels}, {assigned/removedNodeProperties}")
    public List<Node> nodesByLabel(@Name(value="labelEntries") Object entries, @Name(value="label") String labelString) {
        List list;
        if (!(entries instanceof Map)) {
            return Collections.emptyList();
        }
        Map map = (Map)entries;
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        Object result = ((Map)entries).get(labelString);
        if (result instanceof List) {
            return (List)result;
        }
        Object anEntry = map.values().iterator().next();
        if (anEntry instanceof List && !(list = (List)anEntry).isEmpty()) {
            if (list.get(0) instanceof Map) {
                HashSet<Node> nodeSet = new HashSet<Node>(100);
                Label label = labelString == null ? null : Label.label((String)labelString);
                for (List entry : map.values()) {
                    for (Map propertyEntry : entry) {
                        Object node = propertyEntry.get("node");
                        if (!(node instanceof Node) || label != null && !((Node)node).hasLabel(label)) continue;
                        nodeSet.add((Node)node);
                    }
                }
                if (!nodeSet.isEmpty()) {
                    return new SetBackedList<Node>(nodeSet);
                }
            } else if (list.get(0) instanceof Node && labelString == null) {
                HashSet nodeSet = new HashSet(map.size() * list.size());
                map.values().forEach(l -> nodeSet.addAll((Collection)l));
                return new SetBackedList<Node>(nodeSet);
            }
        }
        return Collections.emptyList();
    }

    @UserFunction
    @Description(value="function to filter propertyEntries by property-key, to be used within a trigger kernelTransaction with {assignedNode/RelationshipProperties} and {removedNode/RelationshipProperties}. Returns [{old,new,key,node,relationship}]")
    public List<Map<String, Object>> propertiesByKey(@Name(value="propertyEntries") Map<String, List<Map<String, Object>>> propertyEntries, @Name(value="key") String key) {
        return propertyEntries.getOrDefault(key, Collections.emptyList());
    }

    public TriggerInfo toTriggerInfo(Map.Entry<String, Object> e) {
        String name = e.getKey();
        if (e.getValue() instanceof Map) {
            try {
                Map value = (Map)e.getValue();
                return new TriggerInfo(name, (String)value.get("statement"), (Map)value.get("selector"), (Map)value.get("params"), false, false);
            }
            catch (Exception ex) {
                return new TriggerInfo(name, ex.getMessage(), null, false, false);
            }
        }
        return new TriggerInfo(name, null, null, false, false);
    }

    public static class TriggerInfo {
        public String name;
        public String query;
        public Map<String, Object> selector;
        public Map<String, Object> params;
        public boolean installed;
        public boolean paused;

        public TriggerInfo(String name, String query, Map<String, Object> selector, boolean installed, boolean paused) {
            this.name = name;
            this.query = query;
            this.selector = selector;
            this.installed = installed;
            this.paused = paused;
        }

        public TriggerInfo(String name, String query, Map<String, Object> selector, Map<String, Object> params, boolean installed, boolean paused) {
            this.name = name;
            this.query = query;
            this.selector = selector;
            this.params = params;
            this.installed = installed;
            this.paused = paused;
        }
    }
}

