/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.convert.Convert;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.helpers.collection.Iterables;

public class TriggerMetadata {
    private final long transactionId;
    private final long commitTime;
    private final List<Node> createdNodes;
    private final List<Relationship> createdRelationships;
    private final List<Node> deletedNodes;
    private final List<Relationship> deletedRelationships;
    private final Map<String, List<Node>> removedLabels;
    private final Map<String, List<PropertyEntryContainer<Node>>> removedNodeProperties;
    private final Map<String, List<PropertyEntryContainer<Relationship>>> removedRelationshipProperties;
    private final Map<String, List<Node>> assignedLabels;
    private final Map<String, List<PropertyEntryContainer<Node>>> assignedNodeProperties;
    private final Map<String, List<PropertyEntryContainer<Relationship>>> assignedRelationshipProperties;
    private final Map<String, Object> metaData;

    private TriggerMetadata(long transactionId, long commitTime, List<Node> createdNodes, List<Relationship> createdRelationships, List<Node> deletedNodes, List<Relationship> deletedRelationships, Map<String, List<Node>> removedLabels, Map<String, List<PropertyEntryContainer<Node>>> removedNodeProperties, Map<String, List<PropertyEntryContainer<Relationship>>> removedRelationshipProperties, Map<String, List<Node>> assignedLabels, Map<String, List<PropertyEntryContainer<Node>>> assignedNodeProperties, Map<String, List<PropertyEntryContainer<Relationship>>> assignedRelationshipProperties, Map<String, Object> metaData) {
        this.transactionId = transactionId;
        this.commitTime = commitTime;
        this.createdNodes = createdNodes;
        this.createdRelationships = createdRelationships;
        this.deletedNodes = deletedNodes;
        this.deletedRelationships = deletedRelationships;
        this.removedLabels = removedLabels;
        this.removedNodeProperties = removedNodeProperties;
        this.removedRelationshipProperties = removedRelationshipProperties;
        this.assignedLabels = assignedLabels;
        this.assignedNodeProperties = assignedNodeProperties;
        this.assignedRelationshipProperties = assignedRelationshipProperties;
        this.metaData = metaData;
    }

    public static TriggerMetadata from(TransactionData txData, boolean rebindDeleted) {
        long commitTime;
        long txId;
        try {
            txId = txData.getTransactionId();
        }
        catch (Exception ignored) {
            txId = -1L;
        }
        try {
            commitTime = txData.getCommitTime();
        }
        catch (Exception ignored) {
            commitTime = -1L;
        }
        List createdNodes = Convert.convertToList(txData.createdNodes());
        List createdRelationships = Convert.convertToList(txData.createdRelationships());
        List<Node> deletedNodes = rebindDeleted ? TriggerMetadata.rebindDeleted(Convert.convertToList(txData.deletedNodes())) : Convert.convertToList(txData.deletedNodes());
        List<Relationship> deletedRelationships = rebindDeleted ? TriggerMetadata.rebindDeleted(Convert.convertToList(txData.deletedRelationships())) : Convert.convertToList(txData.deletedRelationships());
        Map<String, List<Node>> removedLabels = TriggerMetadata.aggregateLabels(txData.removedLabels());
        Map<String, List<Node>> assignedLabels = TriggerMetadata.aggregateLabels(txData.assignedLabels());
        Map<String, List<PropertyEntryContainer<Node>>> removedNodeProperties = TriggerMetadata.aggregatePropertyKeys(txData.removedNodeProperties(), true);
        Map<String, List<PropertyEntryContainer<Relationship>>> removedRelationshipProperties = TriggerMetadata.aggregatePropertyKeys(txData.removedRelationshipProperties(), true);
        Map<String, List<PropertyEntryContainer<Node>>> assignedNodeProperties = TriggerMetadata.aggregatePropertyKeys(txData.assignedNodeProperties(), false);
        Map<String, List<PropertyEntryContainer<Relationship>>> assignedRelationshipProperties = TriggerMetadata.aggregatePropertyKeys(txData.assignedRelationshipProperties(), false);
        return new TriggerMetadata(txId, commitTime, createdNodes, createdRelationships, deletedNodes, deletedRelationships, removedLabels, removedNodeProperties, removedRelationshipProperties, assignedLabels, assignedNodeProperties, assignedRelationshipProperties, txData.metaData());
    }

    private static <T extends Entity> List<T> rebindDeleted(List<T> entities2) {
        return entities2.stream().map(e -> {
            if (e instanceof Node) {
                Node node = (Node)e;
                Label[] labels2 = (Label[])Iterables.asArray(Label.class, (Iterable)node.getLabels());
                return new VirtualNode(labels2, e.getAllProperties());
            }
            Relationship rel = (Relationship)e;
            return new VirtualRelationship(rel.getStartNode(), rel.getEndNode(), rel.getType());
        }).collect(Collectors.toList());
    }

    public TriggerMetadata rebind(Transaction tx) {
        List<Node> createdNodes = Util.rebind(this.createdNodes, tx);
        List<Relationship> createdRelationships = Util.rebind(this.createdRelationships, tx);
        Map<String, List<Node>> removedLabels = this.rebindMap(this.removedLabels, tx);
        Map<String, List<Node>> assignedLabels = this.rebindMap(this.assignedLabels, tx);
        Map<String, List<PropertyEntryContainer<Node>>> removedNodeProperties = this.rebindPropertyEntryContainer(this.removedNodeProperties, tx);
        Map<String, List<PropertyEntryContainer<Relationship>>> removedRelationshipProperties = this.rebindPropertyEntryContainer(this.removedRelationshipProperties, tx);
        Map<String, List<PropertyEntryContainer<Node>>> assignedNodeProperties = this.rebindPropertyEntryContainer(this.assignedNodeProperties, tx);
        Map<String, List<PropertyEntryContainer<Relationship>>> assignedRelationshipProperties = this.rebindPropertyEntryContainer(this.assignedRelationshipProperties, tx);
        return new TriggerMetadata(this.transactionId, this.commitTime, createdNodes, createdRelationships, this.deletedNodes, this.deletedRelationships, removedLabels, removedNodeProperties, removedRelationshipProperties, assignedLabels, assignedNodeProperties, assignedRelationshipProperties, this.metaData);
    }

    private <T extends Entity> Map<String, List<PropertyEntryContainer<T>>> rebindPropertyEntryContainer(Map<String, List<PropertyEntryContainer<T>>> map, Transaction tx) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().map(p -> p.rebind(tx)).collect(Collectors.toList())));
    }

    private <T extends Entity> Map<String, List<T>> rebindMap(Map<String, List<T>> map, Transaction tx) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Util.rebind((List)e.getValue(), tx)));
    }

    private <T extends Entity> Map<String, List<Map<String, Object>>> convertMapOfPropertyEntryContainers(Map<String, List<PropertyEntryContainer<T>>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().map(PropertyEntryContainer::toMap).collect(Collectors.toList())));
    }

    public Map<String, Object> toMap() {
        return Util.map("transactionId", this.transactionId, "commitTime", this.commitTime, "createdNodes", this.createdNodes, "createdRelationships", this.createdRelationships, "deletedNodes", this.deletedNodes, "deletedRelationships", this.deletedRelationships, "removedLabels", this.removedLabels, "removedNodeProperties", this.convertMapOfPropertyEntryContainers(this.removedNodeProperties), "removedRelationshipProperties", this.convertMapOfPropertyEntryContainers(this.removedRelationshipProperties), "assignedLabels", this.assignedLabels, "assignedNodeProperties", this.convertMapOfPropertyEntryContainers(this.assignedNodeProperties), "assignedRelationshipProperties", this.convertMapOfPropertyEntryContainers(this.assignedRelationshipProperties), "metaData", this.metaData);
    }

    private static Map<String, List<Node>> aggregateLabels(Iterable<LabelEntry> labelEntries) {
        if (!labelEntries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Node>> result = new HashMap<String, List<Node>>();
        for (LabelEntry entry : labelEntries) {
            result.compute(entry.label().name(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Node>(100);
                }
                v.add(entry.node());
                return v;
            });
        }
        return result;
    }

    private static <T extends Entity> Map<String, List<PropertyEntryContainer<T>>> aggregatePropertyKeys(Iterable<PropertyEntry<T>> entries, boolean removed) {
        if (!entries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<PropertyEntryContainer<T>>> result = new HashMap<String, List<PropertyEntryContainer<T>>>();
        for (PropertyEntry entry : entries) {
            result.compute(entry.key(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<PropertyEntryContainer<Entity>>(100);
                }
                v.add(new PropertyEntryContainer<Entity>((String)k, (Entity)entry.entity(), entry.previouslyCommittedValue(), removed ? null : entry.value()));
                return v;
            });
        }
        return result;
    }

    private static class PropertyEntryContainer<T extends Entity> {
        private final String key;
        private final T entity;
        private final Object oldVal;
        private final Object newVal;

        PropertyEntryContainer(String key, T entity, Object oldVal, Object newVal) {
            this.key = key;
            this.entity = entity;
            this.oldVal = oldVal;
            this.newVal = newVal;
        }

        PropertyEntryContainer<T> rebind(Transaction tx) {
            return new PropertyEntryContainer<T>(this.key, Util.rebind(tx, this.entity), this.oldVal, this.newVal);
        }

        Map<String, Object> toMap() {
            Map<String, Object> map = Util.map("key", this.key, this.entity instanceof Node ? "node" : "relationship", this.entity, "old", this.oldVal);
            if (this.newVal != null) {
                map.put("new", this.newVal);
            }
            return map;
        }
    }
}

