/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.CompressionAlgo;
import apoc.util.CompressionConfig;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.UserFunction;

public class Utils {
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;

    @UserFunction
    @Description(value="apoc.util.sha1([values]) | computes the sha1 of the concatenation of all string values of the list")
    public String sha1(@Name(value="values") List<Object> values) {
        String value = values.stream().map(v -> v == null ? "" : v.toString()).collect(Collectors.joining());
        return DigestUtils.sha1Hex(value);
    }

    @UserFunction
    @Description(value="apoc.util.sha256([values]) | computes the sha256 of the concatenation of all string values of the list")
    public String sha256(@Name(value="values") List<Object> values) {
        String value = values.stream().map(v -> v == null ? "" : v.toString()).collect(Collectors.joining());
        return DigestUtils.sha256Hex(value);
    }

    @UserFunction
    @Description(value="apoc.util.sha384([values]) | computes the sha384 of the concatenation of all string values of the list")
    public String sha384(@Name(value="values") List<Object> values) {
        String value = values.stream().map(v -> v == null ? "" : v.toString()).collect(Collectors.joining());
        return DigestUtils.sha384Hex(value);
    }

    @UserFunction
    @Description(value="apoc.util.sha512([values]) | computes the sha512 of the concatenation of all string values of the list")
    public String sha512(@Name(value="values") List<Object> values) {
        String value = values.stream().map(v -> v == null ? "" : v.toString()).collect(Collectors.joining());
        return DigestUtils.sha512Hex(value);
    }

    @UserFunction
    @Description(value="apoc.util.md5([values]) | computes the md5 of the concatenation of all string values of the list")
    public String md5(@Name(value="values") List<Object> values) {
        String value = values.stream().map(v -> v == null ? "" : v.toString()).collect(Collectors.joining());
        return DigestUtils.md5Hex(value);
    }

    @Procedure
    @Description(value="apoc.util.sleep(<duration>) | sleeps for <duration> millis, transaction termination is honored")
    public void sleep(@Name(value="duration") long duration) throws InterruptedException {
        long started = System.currentTimeMillis();
        while (System.currentTimeMillis() - started < duration) {
            try {
                Thread.sleep(5L);
                this.terminationGuard.check();
            }
            catch (TransactionTerminatedException e) {
                return;
            }
        }
    }

    @Procedure
    @Description(value="apoc.util.validate(predicate, message, params) | if the predicate yields to true raise an exception")
    public void validate(@Name(value="predicate") boolean predicate, @Name(value="message") String message, @Name(value="params") List<Object> params) {
        if (predicate) {
            if (params != null && !params.isEmpty()) {
                message = String.format(message, params.toArray(new Object[params.size()]));
            }
            throw new RuntimeException(message);
        }
    }

    @UserFunction
    @Description(value="apoc.util.validatePredicate(predicate, message, params) | if the predicate yields to true raise an exception else returns true, for use inside WHERE subclauses")
    public boolean validatePredicate(@Name(value="predicate") boolean predicate, @Name(value="message") String message, @Name(value="params") List<Object> params) {
        if (predicate) {
            if (params != null && !params.isEmpty()) {
                message = String.format(message, params.toArray(new Object[params.size()]));
            }
            throw new RuntimeException(message);
        }
        return true;
    }

    @UserFunction
    @Description(value="apoc.util.decompress(compressed, {config}) | return a string from a compressed byte[] in various format")
    public String decompress(@Name(value="data") byte[] data, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        CompressionConfig conf = new CompressionConfig(config);
        return CompressionAlgo.valueOf(conf.getCompressionAlgo()).decompress(data, conf.getCharset());
    }

    @UserFunction
    @Description(value="apoc.util.compress(string, {config}) | return a compressed byte[] in various format from a string")
    public byte[] compress(@Name(value="data") String data, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        CompressionConfig conf = new CompressionConfig(config);
        return CompressionAlgo.valueOf(conf.getCompressionAlgo()).compress(data, conf.getCharset());
    }
}

