/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.google.cloud;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.neo4j.util.VisibleForTesting;

public class GCStorageURLConnection
extends URLConnection {
    private Blob blob;

    public GCStorageURLConnection(URL url) {
        super(url);
    }

    @VisibleForTesting
    public Storage getStorage(URI uri) {
        Storage storage;
        Map<String, String> queryParams = this.getQueryParams(uri);
        AuthType authenticationType = AuthType.valueOf(queryParams.getOrDefault("authenticationType", AuthType.NONE.toString()));
        switch (authenticationType) {
            case PRIVATE_KEY: {
                String googleAppCredentialsEnv = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
                if (StringUtils.isBlank(googleAppCredentialsEnv)) {
                    throw new RuntimeException("You must set the env variable GOOGLE_APPLICATION_CREDENTIALS as described here: https://cloud.google.com/storage/docs/reference/libraries#client-libraries-install-java");
                }
            }
            case GCP_ENVIRONMENT: {
                storage = (Storage)StorageOptions.getDefaultInstance().getService();
                break;
            }
            default: {
                storage = (Storage)StorageOptions.getUnauthenticatedInstance().getService();
            }
        }
        return storage;
    }

    private Map<String, String> getQueryParams(URI uri) {
        Map<String, String> queryParams = StringUtils.isBlank(uri.getQuery()) ? Collections.emptyMap() : Stream.of(uri.getQuery().split("&")).map(e -> e.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
        return queryParams;
    }

    @Override
    public void connect() {
        try {
            URI uri = this.url.toURI();
            if (StringUtils.isBlank(uri.getPath())) {
                throw new RuntimeException("Please provide the file name");
            }
            this.blob = this.getStorage(uri).get(BlobId.of((String)uri.getAuthority(), (String)uri.getPath().substring(1)));
            this.connected = true;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getContentType() {
        return this.blob.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        InputStream in = this.blob == null ? new ByteArrayInputStream(new byte[0]) : Channels.newInputStream((ReadableByteChannel)this.blob.reader(new Blob.BlobSourceOption[0]));
        return in;
    }

    static enum AuthType {
        NONE,
        PRIVATE_KEY,
        GCP_ENVIRONMENT;

    }
}

