/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.hdfs;

import apoc.util.FileUtils;
import apoc.util.StreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSUtils {
    private HDFSUtils() {
    }

    public static StreamConnection readFile(String fileName) throws IOException {
        final FileSystem hdfs = HDFSUtils.getFileSystem(fileName);
        final Path file = HDFSUtils.getPath(fileName);
        final FileStatus fileStatus = hdfs.getFileStatus(file);
        return new StreamConnection(){

            @Override
            public InputStream getInputStream() throws IOException {
                return hdfs.open(file);
            }

            @Override
            public String getEncoding() {
                return "";
            }

            @Override
            public long getLength() {
                return fileStatus.getLen();
            }
        };
    }

    public static StreamConnection readFile(URL url) throws IOException {
        return HDFSUtils.readFile(url.toString());
    }

    private static String getHDFSUri(String fileName) {
        Matcher matcher = FileUtils.HDFS_PATTERN.matcher(fileName);
        if (!matcher.find()) {
            throw new RuntimeException("Not valid HDFS url");
        }
        return matcher.group();
    }

    public static OutputStream writeFile(String fileName) throws IOException {
        FileSystem hdfs = HDFSUtils.getFileSystem(fileName);
        Path file = HDFSUtils.getPath(fileName);
        return hdfs.create(file);
    }

    public static Path getPath(String fileName) {
        String path = fileName.replace(HDFSUtils.getHDFSUri(fileName), "");
        return new Path(path);
    }

    public static FileSystem getFileSystem(String fileName) throws IOException {
        String hdfsUri = HDFSUtils.getHDFSUri(fileName);
        Configuration configuration = new Configuration();
        return FileSystem.get((URI)HDFSUtils.toUri(hdfsUri), (Configuration)configuration);
    }

    public static URI toUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

